/*----------------------------------------------------------------------------

  Copyright (C) 1995-6, Vipul Gupta and Abhijit Dixit. Created 1995-6. All
  rights reserved.

  Linux-Mobile-IP
            An implementation of Mobile IP for the LINUX operating system
            developed at the State University of New York, Binghamton
            (with partial support from the Center for Computing Technologies).
            Except as noted in the accompanying documentation, this
            implementation complies with revision 16 of the Internet 
            Engineering Task Force (IETF) Mobile-IP draft.

            More information can be obtained from:
                  http://anchor.cs.binghamton.edu/~mobileip/  

  Version:   1.00     05/23/1996
 
  Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu> 
             Vipul Gupta <vgupta@cs.binghamton.edu>
             Benjamin Lancki <ben@anchor.cs.binghamton.edu>

  Permission is hereby granted to redistribute this code and/or
  modify it under the terms of the GNU Genral Public License
  as published by the Free Software Foundation; either version
  two or (at your option) any later version provided this ENTIRE
  notice is retained in any copies or any part of this software.

  A copy of the GNU General Public License can be obtained by contacting
  the Free Software Foundation, Inc. 675 Mass Ave, Cambridge, MA 02139, USA.
             
-----------------------------------------------------------------------------*/
 

        /* utils.c - Various utility functions. */

#include <stdio.h>
#include <sys/time.h>
#include "messages.h"

void printext(char *buf,int len,int flag) {
  char *msgptr;
  int skipover;
  int bytesseen=0;
  
  msgptr=buf;

  /* jump to offset in message where extensions begin, extensions offset 
     determined by message type */
  bytesseen=(flag) ? sizeof(struct regreply) : sizeof(struct registerme);
  msgptr+=bytesseen;

  /* keep looking for extension until end of message is reached  */
  while(bytesseen<len) {
    fprintf(stderr,"\nExtension: %d  Length: %d", (unsigned char)*msgptr, 
            (unsigned char)*(msgptr+1));
    skipover=*(msgptr+1);
    bytesseen+=skipover+2;
    msgptr+=skipover+2;
  }
}

void testprint(char *buf,int buflen) {
  int i;

  for(i=0;i<buflen;i++)
    fprintf(stderr,"%2x |",(unsigned char)*(buf+i));
  fprintf(stderr,"\n");
} 

void printtime() {
  struct timeval clock;
  struct timezone zone;
  time_t temp;

  gettimeofday(&clock,&zone);
  temp = (time_t) clock.tv_sec;
  fprintf(stderr,"%s\n",ctime(&temp));
}

int
in_cksum(u_short *addr,int len)

{
	register int nleft = len;
	register u_short *w = addr;
	register u_short answer;
	u_short odd_byte = 0;
	register int sum = 0;

	/*
	 *  Our algorithm is simple, using a 32 bit accumulator (sum),
	 *  we add sequential 16 bit words to it, and at the end, fold
	 *  back all the carry bits from the top 16 bits into the lower
	 *  16 bits.
	 */
	while( nleft > 1 )  {
		sum += *w++;
		nleft -= 2;
	}

	/* mop up an odd byte, if necessary */
	if( nleft == 1 ) {
		*(u_char *)(&odd_byte) = *(u_char *)w;
		sum += odd_byte;
	}

	/*
	 * add back carry outs from top 16 bits to low 16 bits
	 */
	sum = (sum >> 16) + (sum & 0xffff);	/* add hi 16 to low 16 */
	sum += (sum >> 16);			/* add carry */
	answer = ~sum;				/* truncate to 16 bits */
	return (answer);
      }
