/* config.h    general configuration info
 *
 * Copyright 1991, Michael Westerhof, Sun Microsystems, Inc.
 * This software may be freely used, distributed, or modified, providing
 * this header is not removed.
 * 
 */

/* 
 * Modifications added for dual port kiss TNC 
 * by Michael Durrant and D. Jeff Dionne Feb 4, 1995
 */


#define CONFIG_FILE "./ax25ip.cfg"
#define IPPROTO_AX25 93
#define DEFAULT_UDP_PORT 10093

int udp_mode;                   /* true if we need a UDP socket */
int ip_mode;                    /* true if we need the raw IP socket */
unsigned short my_udp;          /* the UDP port to use (network byte order) */
char ttydevice[128];            /* the tty device for serial comms */
int ttyspeed;                   /* The baud rate on the tty device */
unsigned char mycallsign[7];    /* My callsign, shifted ASCII with SSID */
unsigned char mycallsign2[7];   /* My seconds port callsign, shifted ASCII with SSID */
unsigned char myalias[7];       /* An alias to use */
unsigned char myalias2[7];      /* An alias for second port */
char bc_text[128];              /* The text for beacon messages */
int bc_interval;                /* The interval, in seconds, between beacons */
int bc_every;                   /* true=every, false=after */
int digi;                       /* True if we are connected to a TNC */
int loglevel;                   /* Verbosity level */
/* addition for dual port flag */
int dual_port;

struct {
	int kiss_in;            /* # packets received */
	int kiss_toobig;        /* packet too large */
	int kiss_badtype;       /* control byte non-zero */
	int kiss_out;           /* # packets sent */
	int kiss_beacon_outs;   /* # of beacons sent */
	int kiss_tooshort;      /* packet too short to be a valid frame */
	int kiss_not_for_me;    /* packet not for me (in digi mode) */
	int kiss_i_am_dest;     /* I am destination (in digi mode) */
	int kiss_no_ip_addr;    /* Couldn't find an IP addr for this call */
	int udp_in;             /* # packets received */
	int udp_out;            /* # packets sent */
	int ip_in;              /* # packets received */
	int ip_out;             /* # packets sent */
	int ip_failed_crc;      /* from ip, but failed CRC check */
	int ip_tooshort;        /* packet too short to be a valid frame */
	int ip_not_for_me;      /* packet not for me (in digi mode) */
	int ip_i_am_dest;       /* I am destination (in digi mode) */
} stats;

#define MAX_FRAME 2048

#define LOGL1 if(loglevel>0)(void)printf
#define LOGL2 if(loglevel>1)(void)printf
#define LOGL3 if(loglevel>2)(void)printf
#define LOGL4 if(loglevel>3)(void)printf

/* kiss.c */
void kiss_init();
void assemble_kiss();
void send_kiss();
void param_add();
void dump_params();
void send_params();
void do_beacon();

/* routing.c */
void route_init();
void route_add();
unsigned char *call_to_ip();
void dump_routes();

/* config.c */
void config_init();
void config_read();
int parse_line();
int a_to_call();
char *call_to_a();
void dump_config();

/* process.c */
void process_init();
void from_ip();
void from_kiss();
void do_broadcast();
int addrmatch();
unsigned char *next_addr();
void add_crc();
void dump_ax25frame();

/* io.c */
void io_init();
void io_open();
void io_start();
void send_tty();
void send_ip();
int io_error();

/* crc.c */
unsigned short int compute_crc();
int ok_crc();

/* main.c */
void greet_world();
void do_stats();
void hupper();
void usr1_handler();
void int_handler();
void term_handler();
