/* $Id: axssh.c,v 1.2 1997/05/25 21:00:46 jreuter Exp jreuter $
 * 
 * Copyright 1997, Jrg Reuter DL1BKE <jreuter@poboxes.com>
 *
 * Needs the ssh (secure shell) package (available from most mirrors
 * of ftp.cs.helsinki.fi). Note that amateur radio legislation in your
 * country may limit the use of this program to system administration
 * or forbid it at all, as Ssh uses (strong) encryption.
 *
 * NOTE: This program is a hack. Don't expect too much from the linemode
 *       editing facility. Anything better would require ncurses and
 *       a terminal emulation...
 *
 * INSTALL
 * =======
 *
 * 1.	Get and install Ssh
 * 2.	Adjust SSH_PATH to your needs (see below)
 * 3.	compile with gcc -O axlogin.c -o axlogin
 * 4.	copy the file to /usr/local/bin or what-so-ever
 *
 * Axssh takes the same options as Ssh with one exception: "-C"
 * gets added to the options automatically.
 * You might wish to add a "stty -echo" into remote's .profile.
 *
 * USAGE
 * =====
 *
 * axssh [SSH-Options] hostname
 *
 * Examples:
 *
 * axssh db0axx.ampr.org
 *	Login as local user on db0xxx.ampr.org, use encryption if
 *	run as root, disable encryption otherwise.
 *
 * axssh -l root db0xxx.ampr.org
 *	Login as root on db0xxx.ampr.org, encrypted communication
 *
 * axssh -l root -c none db0xxx.ampr.org
 *	Login as root, no encryption
 *
 * axssh -l dl1bke db0xxx.ampr.org
 *	Login as "dl1bke", no encryption
 *
 *
 * TODO
 * ====
 *
 * 1. use ncurses
 * 2. command scroll back
 *
 * -------------------------------------------------------------------------
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *                
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 */

#undef DEBUG

#ifdef DEBUG
#define SSH_PATH "/root/xxx"
#else
#define SSH_PATH "/usr/local/bin/ssh"
#endif

#define INLINE inline

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <strings.h>
#include <ctype.h>
#include <termios.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/file.h>


pid_t forkpty(int *, char *, void *, struct winsize *);

char ptyslave[20];
int child_pid;

struct termios old_termios;

enum KeyModes {NORMAL, ESC, META, ANSI, ANSI_OP1, ANSI_OP2};

void cleanup(int retcode)
{
	tcsetattr(0, TCSANOW, &old_termios);
	exit(retcode);
}

void signal_handler(int dummy)
{
	kill(child_pid, SIGHUP);
	cleanup(1);
}


static INLINE void
Putch(char x)
{
	static char ch[2] = {'^',' '};

	if (x < 32 || x == 127)
	{
		ch[1] = x+64;
		write(1, ch, 2);
	} else {
		write(1, &x, 1);
	}
}

static INLINE void
putch(unsigned char x)
{
	write(1, &x, 1);
}

static INLINE void
backch(unsigned char x)
{
	static char *s = "\b\b";
	if (x < 32 || x == 127)
		write(1, s, 2);
	else
		write(1, s, 1);
}

void 
do_input(unsigned char ch, int fd)
{
	static unsigned char line[1024];
	static unsigned char delbuf[1024];
	static int len = 0;
	static int cursor = 0;
	static int mode = 0;
	static unsigned char last_char;
	int k;
	
	if (mode == META)
	{
		if (ch == '[')
		{
			mode = ANSI;
		} else {
			write(fd, &ch, 1);
			mode = NORMAL;
		}
		return;
	}
	
	if (mode == ANSI_OP1)
	{
		mode = NORMAL;
		return;
	}
	
	if (mode == ANSI)
	{
		last_char = ch;
		mode = ANSI_OP1;
		mode = NORMAL;

		switch(ch)
		{
			case '1': ch = '\001'; mode = ANSI_OP1;	break;	/* HOME */
			case '4': ch = '\005'; mode = ANSI_OP1;	break;	/* END */
			case '3': ch = '\004'; mode = ANSI_OP1;	break;	/* DELETE */
			case 'C': ch = '\006'; mode = NORMAL;	break; 	/* RIGHT */
			case 'D': ch = '\002'; mode = NORMAL;	break;	/* LEFT */
			case 'A': ch = '\020'; mode = NORMAL;	break;	/* UP (^P) */
			case 'B': ch = '\016'; mode = NORMAL;	break;	/* DOWN (^N) */
			default: return;
		}
	}

	if (mode != ESC)
	{
		switch(ch)
		{
			case 127:			/* Delete */
			case '\010':			/* Backspace */
				if (cursor <= 0)
				{
					putch('\a');
					return;
				}
				cursor--;
				backch(line[cursor]);

			case '\004':			/* Erase */
				if (len <= cursor)
				{
					putch('\a');
					return;
				}

				for (k = cursor; k < len-1; k++)
				{
					line[k] = line[k+1];
					Putch(line[k]);
				}

				if (line[k] < 32)
					putch(' ');
				putch(' ');
				
				len--;
				for (k = len ; k >= cursor ; k--)
					backch(line[k]);
				return;

			case '\001':			/* Home */
				for (; cursor > 0; cursor--)
					backch(line[k]);
				return;
				
			case '\005':			/* End */
				for (; cursor < len; cursor++)
					Putch(line[cursor]);
				return;

			case '\006':			/* Right */
				if (cursor < len)
				{
					Putch(line[cursor]);
					cursor++;
				} else
					putch('\a');
				return;

			case '\002':			/* Left */
				if (cursor > 0)
				{
					cursor--;
					backch(line[cursor]);
				} else
					putch('\a');
				return;

			case '\020':			/* Up */
				return;
			case '\016':			/* Down */
				return;

			case '\003':			/* ^C */
				write(1, "^C\n", 3);
				len = cursor = 0;
				write(fd, "\003", 1);
				return;

			case '\025':			/* ^U: clear BOL */
				return;
			case '\013':			/* ^K: clear EOL */
				return;
			case '\031':			/* ^Y: insert delbuf */
				return;
			case '\026':			/* ^V: ESCAPE control character */
				mode = ESC;
				return;
			case '\033':
				mode = META;
				return;
			case '\n':
			case '\r':			/* new line */
				line[len] = '\n';
				putch('\n');
				write(fd, line, len+1);
				len = cursor = 0;
				return;
		}
		if (ch < 32 && ch != '\t')
			return;
	}
	
	if (cursor < sizeof(line)-1)
	{
		for (k = len; k >= cursor; k--)
			line[k] = line[k-1];

		line[cursor++] = ch;
		len++;

		Putch(ch);
		for (k = cursor; k < len; k++)
			Putch(line[k]);
		for (k = cursor; k < len; k++)
			backch(line[k]);
	} else putch('\a');
	
	mode = NORMAL;
}

			
int main(int argc, char **argv)
{
	unsigned char buf[2048];
	int  k, cnt, encrypt;
	int  fdmaster;
	pid_t pid = -1;
	fd_set fds_read, fds_err;
	int  chargc;
	char *chargv[20];
	int envc;
	char *envp[20];
	struct termios termios;
	struct winsize win = { 0, 0, 0, 0};
	
	pid = forkpty(&fdmaster, ptyslave, NULL, &win);
	
	if (pid == 0)
	{
		encrypt = (getuid() == 0);

		/*
		 * Complete path to ssh
		 */

                chargc = 0;
                chargv[chargc++] = SSH_PATH;

                /*
                 * -C for Compression
                 */
                 
                chargv[chargc++] = "-C";

                for (k = 1; k < argc; k++)
                {
                	chargv[chargc++] = argv[k];
                	if (k+1 < argc && !strcmp(argv[k], "-l") && !strcmp(argv[k+1], "root"))
                	    	encrypt=1;
                }
                
                /*
                 * use encryption on root logins only.
                 */
                
                if (!encrypt)
                {
                	chargv[chargc++] = "-c";
                	chargv[chargc++] = "none";
                }

                chargv[chargc]   = NULL;

		envc = 0;
		envp[envc] = NULL;

                execve(chargv[0], chargv, envp);
        }
        else if (pid > 0)
        {
        	child_pid = 0;
        	signal(SIGHUP, signal_handler);
        	signal(SIGTERM, signal_handler);
        	signal(SIGINT, signal_handler);
        	signal(SIGQUIT, signal_handler);

		tcgetattr(0, &old_termios);
        	memset((char *) &termios, 0, sizeof(termios));
 
        	ioctl(0, TIOCSCTTY, (char *) 0);
		termios.c_iflag = ICRNL | IXOFF;
            	termios.c_oflag = OPOST | ONLCR;
                termios.c_cflag = CS8 | CREAD;
		termios.c_lflag = 0;
		memcpy(termios.c_cc, old_termios.c_cc, sizeof(termios.c_cc));
                cfsetispeed(&termios, B19200);
                cfsetospeed(&termios, B19200);
                tcsetattr(0, TCSANOW, &termios);

 
        	while(1)
        	{
        		FD_ZERO(&fds_read);
        		FD_ZERO(&fds_err);
        		FD_SET(0, &fds_read);
        		FD_SET(0, &fds_err);
        		FD_SET(fdmaster, &fds_read);
        		FD_SET(fdmaster, &fds_err);
        		
        		k = select(fdmaster+1, &fds_read, NULL, &fds_err, NULL);
  
        		if (k > 0)
        		{
        			if (FD_ISSET(0, &fds_err))
        			{
        				fprintf(stderr, "lost local TTY\n");
        				kill(pid, SIGHUP);
        				cleanup(1);
        			}
        			
        			if (FD_ISSET(fdmaster, &fds_err))
        			{
        				fprintf(stderr, "remote closed connection\n");
        				cleanup(0);
        			}

        			if (FD_ISSET(0, &fds_read))
        			{
        				/* cnt = read(0, buf, sizeof(buf)); */
        				cnt = read(0, buf, 1);
        				if (cnt < 0)	/* Connection died */
        				{
        					perror("read [console]");
        					kill(pid, SIGHUP);
        					cleanup(1);
        				} else
        					do_input(buf[0], fdmaster);
	       					/* write(fdmaster, buf, cnt); */
        			}
        			
        			if (FD_ISSET(fdmaster, &fds_read))
        			{
        				cnt = read(fdmaster, buf, sizeof(buf));
        				if (cnt < 0) 
        				{
        					perror("read [pipe]");
        					cleanup(1);
        				}
        				write(1, buf, cnt);
        			}
        		} else 
        		if (k < 0 && errno != EINTR)
        		{
        			kill(pid, SIGHUP);	/* just in case... */
        			perror("select");
        			cleanup(1);
        		}
        	}
        } 
        else
        {
        	perror("cannot fork");
        	cleanup(1);
        }

	cleanup(0);
	return 0;
}
  