/*

AXW3 http proxy server and IP/AX25 gateway by Ricardo Ueda
Karpischek (ueda@ime.usp.br).

Version alpha 0.1 (March 98). This code may be used and
redistributed under the terms of the GNU GPL.

TODO:

1. support for other operations than GET (POST, for instance).

*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/wait.h>
#include <errno.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <signal.h>

/* verbosity levels */
#define MUTE 1
#define VERBOSE 2
#define DEBUG 3
int verbose = VERBOSE;

/* statuses */
#define DISCONNECTED 0
#define CONNECTED 1
int status = DISCONNECTED;

/* listen socket */
int lsock;
#define AXW3_PORT 2345

/* client socket */
int clsock,browser_died;

/* details about the requested URL */
char proto[10],remote[100],rport[10],path[1000];

/* command file descriptors */
int fd[2];

/*

Display message and abandon

*/
void abandon (const char *fmt, ...)
{
    va_list args;

    va_start(args,fmt);
    vfprintf(stderr,fmt,args);
    exit(1);
}

/*

    exec_pipe library function
    by Ricardo Ueda Karpischek, Jan 5 1995

    Starts a child command specifying args and environment. Note
    that args[0] must be equal command. Returns in fildes two
    pipe descriptors. All writes in fildes[1] will be read by
    the child in its standard input. All child writes in its
    standard output will be available for reading in fildes[0].
    Returns 1 if successfull, 0 otherwise. If child could not
    start command, it will exit with rc code.

*/
int exec_pipe(command,args,environ,fildes,rc)
    char *command,*args[],*environ[];
    int *fildes,rc;
{
    int i,fd[4],pid;

    /* two pipes by filter */
    pipe(fd); 
    pipe(fd+2);

    /* the lazy way to avoid zombies */
    if ((pid = fork()) == 0) {
        int child;

        /* makes an orphan */
        if ((child=fork()) < 0)
            abandon("could not make an orphan\n");

        else if (child == 0) {

            /* Redirects standard input and output */
            close(fd[1]);
            close(fd[2]);
            dup2(fd[0],0);
            dup2(fd[3],1);

            /* execute the command */
            execve(command,args,environ);
            exit(rc);
        }

        /* the parent is waiting us */
        exit(0);
    }

    /* close descriptors (child side) and returns  */
    else if (pid > 0) {
        wait(NULL);
        close(fd[0]);
        close(fd[3]);
        fildes[0] = fd[2];
        fildes[1] = fd[1];
        return(1);
    }

    /* unable to start child */
    else {
        for (i=0; i<4; ++i) close(fd[i]);
        return(0);
    }
}

/*  
 * listen socket initialization
 */ 
void init_lsock()
{   
    struct sockaddr_in laddr;
    
    /* alloc listen socket */
    if ((lsock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
        abandon("can't alloc listen socket\n");
    
    /* local port */
    (void)bzero(&laddr, sizeof(laddr));
    laddr.sin_family = AF_INET;
    laddr.sin_addr.s_addr = htonl(INADDR_ANY);
    laddr.sin_port = htons(AXW3_PORT);
    if (bind(lsock, (struct sockaddr *)&laddr, sizeof(laddr)) < 0)
        abandon("can't bind listen socket.\nif the call process is running, kill it.\nbe patient, wait one minute and try again.\n");
    listen(lsock,5);
}   

/*

Not sure about the signal to catch here. Must delay and re-stablish
the ax25 connection...

*/
void call_died(int sig)
{
    abandon("CALL died. Giving out\n");
}

/*

A SIGPIPE may be generated by the user when she presses the
break button of the broser, or when the CALL process closes
its input (or when dies?). We are ignoring for the moment
this second possibility.

Unfortunately call(1) does not appear to be able to break
the telnet in course, so this code in fact does not suffice!

*/
void break_button(int sig)
{
    fprintf(stderr,"BROWSER died\n");
    browser_died = 1;
    /* TODO: ask call to break the telnet */
}
    
/*

Perform the following steps:

1. if cdi!=NULL, send to cdi the string cmd.
2. if cdo!=NULL read cdo until one of the stop patterns.
3. if brw>=0, send to brw the text read, except the line that contains
   the pattern stop.

Returns
-------

0 on sucessfull completion
-1 on exception in clsock

*/
int chat(char *cmd,int cdi,int cdo,char *stop[],int brw)
{
    static char buff[1000];
    static int i=0;
    int n,f;

    if (cmd != NULL) {
        write(cdi,cmd,strlen(cmd));
        if (verbose > MUTE)
            write(1,cmd,strlen(cmd));
    }

    if (stop == NULL)
        return(0);

    /*
        loops until receive the pattern stop
    */
    for (f=0; f==0; ) {
        fd_set rfds;
        struct timeval tv;
        int retval;

        if (verbose >= DEBUG)
            printf("waiting input\n");

        /* wait input from cdo */
        for (retval=0; retval==0; ) {
            FD_ZERO(&rfds);
            FD_SET(cdo,&rfds);
            tv.tv_sec = 5;
            tv.tv_usec = 0;
            retval = select(cdo+1, &rfds, NULL, NULL, &tv);
            if (browser_died==1)
                return(-1);
        }

        if ((n = read(cdo,buff+i,999-i)) < 0)
            abandon("error %d while reading command output\n",errno);

        if (n > 0) {
            int j,k,l,lj,lk;

            if (verbose > MUTE) {
                char *b;

                for (j=0,b=buff+i; (j<n) && ((*b==10)||(*b==13)||(31<*b)); ++j,++b);
                if (j >= n)
                    write(1,buff+i,n);
                else
                    printf("[read %d data bytes]\n",n);
            }

            /*
                search the stop patterns line by line. If the pattern is
                found, at the end j and k will point the first and the
                last + 1 buffer positions of the line that contains the
                pattern. If not, at the end j will point the first position
                of the buffer after the last \n found.
            */
            i += n;
            for (j=k=0; (f==0) && (k<i) ; ) {
                for (; (k<i) && (buff[k]!='\n'); ++k);
                if (k < i) {
                    int i;

                    ++k;
                    for (i=0; (f==0) && (stop[i]!=NULL); ++i) {
                        int s=strlen(stop[i]);
                        for (l=j; (f==0) && (l<=k-s); ++l)
                            f = (strncmp(buff+l,stop[i],s) == 0);
                    }

                    if (f == 0)
                        j = k;
                }
            }

            /* send text to the browser */
            if ((brw >= 0) && (j > 0))
                write(brw,buff,j);

            /* pattern found: remove sent text and pattern from buffer */
            if (f == 1) {
                for (l=k; l<i; ++l)
                    buff[l-k] = buff[l];
                i -= k;
            }

            /* pattern not found: remove sent text from buffer */
            else {
                for (l=j; l<i; ++l)
                    buff[l-j] = buff[l];
                i -= j;
            }
        }
    }

    if (verbose >= DEBUG)
        printf("got pattern!\n");
    return(0);
}

/* the query may be very large because of form contents */
char query[65536];
int qs;

void fetch_page(FILE *F)
{
    int bye,lineno,forward=0,connect=0;
    char line[65537],lineb[1000];
    char *args[20];

    /* parse axw3.conf file */
    for (bye=0,lineno=1; (bye==0) && (fgets(lineb,999,F) != NULL); ++lineno) {
        int i,j,k,h;
        char *l;

        /*
            translates tabs to spaces
            removes LFs
            translates %H to remote host name
            translates %P to remote port number
            translates %F to remote path
            translates %Q to full query
            translates \n to LF
        */
        for (i=j=0; (j<65536) && (lineb[i]!=0); ++i)
            if (lineb[i] == '\t')
               line[j++] = ' ';
            else if (lineb[i] == '\n')
               line[j] = 0;
            else if ((lineb[i]=='%') && (lineb[i+1]=='H'))
                for (++i,k=0; (j<65536) && ((line[j]=remote[k])!=0); ++j,++k);
            else if ((lineb[i]=='%') && (lineb[i+1]=='P'))
                for (++i,k=0; (j<65536) && ((line[j]=rport[k])!=0); ++j,++k);
            else if ((lineb[i]=='%') && (lineb[i+1]=='F'))
                for (++i,k=0; (j<65536) && ((line[j]=path[k])!=0); ++j,++k);
            else if ((lineb[i]=='%') && (lineb[i+1]=='Q'))
                for (++i,k=0; (j<65536) && ((line[j]=query[k])!=0); ++j,++k);
            else if ((lineb[i]=='\\') && (lineb[i+1]=='n'))
                ++i,line[j++] = '\n';
            else
                line[j++] = lineb[i];
        if (j >= 65536)
            abandon("axw3.conf line %d too long, giving out\n",lineno);
        line[j] = 0;

        /* CALL keyword */
        if (strncmp(line,"CALL",4) == 0) {

            /* advance to argument start & deduces terminator */
            for (l=line+4; (*l==' '); ++l);
            h = (*l == '"') ? (++l,'"') : 0;

            /* parse command name and arguments */
            for (i=0; (i<14) && (*l!=0); ++i) {

                /* ignore leading spaces & advance l to token end */
                for (; *l==' '; ++l);
                for (args[i]=l; (*l!=h) && (*l!=0) && (*l!=' '); ++l);

                /* mark token end */
                if (*l==' ')
                    *(l++) = 0;
                else if (*l!=h)
                    abandon("unterminated string in axw3.conf at line %d. Giving out\n",lineno);
                else
                    *l = 0;
            }
            args[i] = NULL;

            /* exec CALL command */
            if ((status==DISCONNECTED) && (exec_pipe(args[0],args,NULL,fd,1) == 0))
                abandon("could not exec %s, giving out\n",args[0]);
        }

        /* SEND command */
        else if (strncmp(line,"SEND",4) == 0) {

            /* we don't execute connect commands twice */
            if ((connect==0) || (status==DISCONNECTED)) {
                char *s;

                /* advance to argument start & deduces terminator */
                for (l=line+4; (*l==' '); ++l);
                h = (*l == '"') ? (++l,'"') : 0;
	    
                /* locate argument end and send command */
                for (s=l; (*s!=h) && (*s!=0); ++s);
                if (*s != h)
                    abandon("unterminated string in axw3.conf at line %d. Giving out\n",lineno);
                *s = 0;
                chat(l,fd[1],fd[0],NULL,(forward==0)?-1:clsock);
            }
        }

	/* WAITFOR pattern */
        else if (strncmp(line,"WAITFOR",7) == 0) {

            /* we don't execute connect commands twice */
            if ((connect==0) || (status==DISCONNECTED)) {
                char *s,*stop[10];
                int i;

                /* loops all terminator patterns */
                for (i=0,l=line+7; *l != 0; ++i) {

                    /* advance to argument start and deduces terminator */
                    for (; *l==' '; ++l);
                    h = (*l == '"') ? (++l,'"') : 0;

                    /* locate argument end and */
                    for (s=l; (*s!=h) && (*s!=0); ++s);
                    if (*s != h)
                        abandon("unterminated string in axw3.conf at line %d. Giving out\n",lineno);
                    *s = 0;
                    stop[i] = l;
                    l = s+1;
	            }
                stop[i] = NULL;

                /*wait for string */
                bye = chat(NULL,fd[1],fd[0],stop,(forward==0)?-1:clsock);
            }
        }

        /* FW_ON keyword */
        else if (strncmp(line,"FW_ON",5) == 0)
            forward = 1;

        /* FW_OFF keyword */
        else if (strncmp(line,"FW_OFF",6) == 0)
            forward = 0;

        /* CONNECT keyword */
        else if (strncmp(line,"CONNECT",7) == 0)
            connect = 1;

        /* FETCH keyword */
        else if (strncmp(line,"FETCH",5) == 0) {
            status = CONNECTED;
            connect = 0;
        }

        /* give out if not a comment or blank line */
        else {
            for (l=line; *l==' '; ++l);
            if ((*l!='#') && (*l!=0))
                abandon("error parsing axw3.conf file at line %d, giving out\n",lineno);
        }
    }
}

/*

accept a query from the browser, bufferizes it and parses the GET command
to extract the web server hostname and the port number.

*/
void accept_query(void)
{
    int retval,clilen,lp,exhausted;
    struct sockaddr_in cli_addr;
    fd_set rfds;
    struct timeval tv;

    /* wait connection maintaining the ax25 connection up */
    printf("waiting for connection\n");
    clilen = sizeof(cli_addr);
    for (retval=0; retval==0; ) {

        /* issue an empty command if we're connected */
        if (status == CONNECTED) {
            if (verbose > MUTE)
                printf("issuing empty command to CALL\n");
            chat("\n",fd[1],fd[0],NULL,-1);
        }

        /* Watch clsock to see when it has input */
        FD_ZERO(&rfds);
        FD_SET(lsock,&rfds);

        /* Wait up to 60 seconds. */
        tv.tv_sec = 60;
        tv.tv_usec = 0;
        retval = select(lsock+1, &rfds, NULL, NULL, &tv);
    }

    /* accept the received connection from browser */
    clsock = accept(lsock,(struct sockaddr *)&cli_addr,&clilen);
    if (clsock < 0)
        abandon("error %d while accept-ing\n",errno);
    browser_died = 0;

    /* parse browser request */
    for (qs=exhausted=lp=0; exhausted==0; ) {
        int c,s;

        qs += read(clsock,query+qs,65535-qs);
        for (; lp < qs; ) {
            s = lp;
            while ((lp<qs) && (query[lp]!='\n'))
                ++lp;
            if (lp < qs) {
                c = query[lp+1];
                query[lp+1] = 0;

                /* empty line */
                if ((lp == s) || ((lp-s==1) && (query[s]=='\r')))
                    exhausted = 1;

                /* GET command */
                else if (strncmp(query+s,"GET ",4) == 0) {
                    char *p=query+s;
                    int i;

                    /* protocol */
                    for (i=0; p[i]!=':'; ++i)
                        proto[i] = p[i];
                    proto[i] = 0;

                    /* remote host */
                    p += i + 3;
                    for (i=0; (p[i]!=':') && (p[i]!='/') && (p[i]!=0); ++i)
                        remote[i] = p[i];
                    remote[i] = 0;

                    /* remote port */
                    if (p[i] == ':') {
                        p += i + 1;
                        for (i=0; (p[i]!='/') && (p[i]!=0); ++i)
                            rport[i] = p[i];
                        rport[i] = 0;
                    }
                    else
                        strcpy(rport,"80");

                    /* document path */
                    p += i;
                    strncpy(path,p,999);
                    path[999] = 0;
                }

                printf("%s",query+s);
                query[lp+1] = c;
                s = ++lp;
            }
        }
        lp = s;
    }
    query[qs] = 0;
}

/*

Connection loop. Accepts only one connection at a time.

*/
int main(int argc,char *argv[])
{
    FILE *F;
    char conf[256];

    if ((argc == 3) && (strcmp(argv[1],"-c")==0)) {
        strncpy(conf,argv[2],255);
        conf[255] = 0;
    }
    else
        strcpy(conf,"axw3.conf");

    init_lsock();
    signal(SIGPIPE,break_button);
    /*
    signal(?,call_died);
    */

    /* server loops forever */
    while (1) {

        if ((F = fopen(conf,"r")) == NULL)
            abandon("could not open axw3.conf file. Giving out..\n");

        accept_query();

        fetch_page(F);

        close(clsock);
        fclose(F);

    }
    exit(0);
}

