/*
 * ccd.h
 *
 * image file header
 *
 */

/* for headers with version 0x80 the width is always 611x576 */
/* for headers with version 0x81 the width is defined in the header */

#define WIDTH  611
#define HEIGHT 576

typedef struct
{
  time_t start_time __attribute__ ((packed));
  time_t take_time __attribute__ ((packed));
  unsigned long image_number __attribute__ ((packed));
  unsigned long retries __attribute__ ((packed));
  unsigned long set_image_num __attribute__ ((packed));
  unsigned char integration __attribute__ ((packed));
  unsigned char gain __attribute__ ((packed));
  unsigned char unused[229] __attribute__ ((packed));
  unsigned short  num_pixels __attribute__ ((packed));     /* only if version 0x81 */
  unsigned short  num_lines __attribute__ ((packed));      /* only if version 0x81 */
  unsigned char version __attribute__ ((packed));        /* 0x80 or 0x81 */
} CCDHEADER;

