/*
	FILE: linux.c
	
	Routines: This file contains the following routines:
		fileinit()
		eihalt()
		kbread()
		clksec()
		tmpfile()
		filedir()
		sysreset()
		
	Written by Mikel Matthews, N9DVG
	SYS5 stuff added by Jere Sandidge, K4FUM
*/

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <termios.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/times.h>
#include <dirent.h>
#include <time.h>
#include <unistd.h>

#include "global.h"
#include "cmdparse.h"
#include "iface.h"
#include "unix.h"

#define	MAXCMD	1024

int asy_attach();

extern struct cmds attab[];
extern struct termios savecon;

unsigned nasy;

fileinit()
{
	int el;
	char *ep, *cp, *malloc(), *getenv();
	extern char *startup, *config, *userfile, *hosts, *mailspool;
	extern char *mailqdir, *mailqueue, *routeqdir, *alias;
#ifdef	FINGER
	extern char *fingerpath;
#endif

	/* Try to get home directory name */
	if ((ep = getenv("NETHOME")) == NULLCHAR) {
		if ((ep = getenv("HOME")) == NULLCHAR) {
			ep = ".";
		}
	}
	el = strlen(ep);
	/* Replace each of the file name strings with the complete path */
	if ((cp = malloc(el + strlen(startup) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, startup);
		startup = cp;
	}
	
	if ((cp = malloc(el + strlen(config) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, config);
		config = cp;
	}
	
	if ((cp = malloc(el + strlen(userfile) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, userfile);
		userfile = cp;
	}
	
	if ((cp = malloc(el + strlen(hosts) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, hosts);
		hosts = cp;
	}
	
	if ((cp = malloc(el + strlen(alias) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, alias);
		alias = cp;
	}
	
#ifdef	FINGER
	if ((cp = malloc(el + strlen(fingerpath) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, fingerpath);
		fingerpath = cp;
	}
#endif
	
	/* Try to get home directory name */
	if ((ep = getenv("NETSPOOL")) == NULLCHAR)
		ep = "/usr/spool";
	el = strlen(ep);

	if ((cp = malloc(el + strlen(mailspool) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, mailspool);
		mailspool = cp;
	}
	
	if ((cp = malloc(el + strlen(mailqdir) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, mailqdir);
		mailqdir = cp;
	}
	
	if ((cp = malloc(el + strlen(mailqueue) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, mailqueue);
		mailqueue = cp;
	}
	
	if ((cp = malloc(el + strlen(routeqdir) + 2)) == NULL)
		perror("malloc");
	else {
		sprintf(cp, "%s/%s", ep, routeqdir);
		routeqdir = cp;
	}
	
}

/* action routine for remote reset */
sysreset()
{
	extern char *netexe;

	execl(netexe,netexe,0);
	execl("net","net",0);
	printf("reset failed: exiting\n");
	exit(1);
}

eihalt()
{
	tnix_scan();
}


kbread()
{
	fd_set mask;
	unsigned char c;
	struct timeval timeval;

	timeval.tv_sec  = 0;
	timeval.tv_usec = 0;

	FD_ZERO(&mask);
	FD_SET(STDIN_FILENO, &mask);
	
	select(STDIN_FILENO + 1, &mask, NULL, NULL, &timeval);

	if (!FD_ISSET(STDIN_FILENO, &mask))
		return -1;

	read(STDIN_FILENO, &c, 1);

	return ((int) c);
}


clksec()
{
	long tim;

	(void) time(&tim);

	return ((int) tim);
}


/* wildcard filename lookup */
filedir(name, times, ret_str)
char	*name;
int	times;
char	*ret_str;
{
	static char	dname[128], fname[128];
	static DIR *dirp = NULL;
	struct dirent *dp;
	struct stat sbuf;
	char	*cp, temp[128];

	/*
	 * Make sure that the NULL is there in case we don't find anything
	 */
	ret_str[0] = '\0';

	if (times == 0) {
		/* default a null name to *.* */
		if (name == NULL || *name == '\0')
			name = "*.*";
		/* split path into directory and filename */
		if ((cp = strrchr(name, '/')) == NULL) {
			strcpy(dname, ".");
			strcpy(fname, name);
		} else {
			strcpy(dname, name);
			dname[cp - name] = '\0';
			strcpy(fname, cp + 1);
			/* root directory */
			if (dname[0] == '\0')
				strcpy(dname, "/");
			/* trailing '/' */
			if (fname[0] == '\0')
				strcpy(fname, "*.*");
		}
		/* close directory left over from another call */
		if (dirp != NULL)
			closedir(dirp);
		/* open directory */
		if ((dirp = opendir(dname)) == NULL) {
			printf("Could not open DIR (%s)\n", dname);
			return;
		}
	} else {
		/* for people who don't check return values */
		if (dirp == NULL)
			return;
	}

	/* scan directory */
	while ((dp = readdir(dirp)) != NULL) {
		/* test for name match */
		if (wildmat(dp->d_name, fname)) {
			/* test for regular file */
			sprintf(temp, "%s/%s", dname, dp->d_name);
			if (stat(temp, &sbuf) < 0)
				continue;
			if ((sbuf.st_mode & S_IFMT) != S_IFREG)
				continue;
			strcpy(ret_str, dp->d_name);
			break;
		}
	}

	/* close directory if we hit the end */
	if (dp == NULL) {
		closedir(dirp);
		dirp = NULL;
	}
}


/* checks the time then ticks and updates ISS */
void
check_time()
{
	int32 iss();
	long times();

	struct tms tb;
	static long clkval;
	long ntime, offset;

	/* read elapsed real time (typ. 60 Hz) */
	ntime = times(&tb);

	/* resynchronize if the error is large (10 seconds or more) */
	offset = ntime - clkval;
	if (offset > (10000/MSPTICK) || offset < 0)
		clkval = ntime;

	/* Handle possibility of several missed ticks */
	while (ntime != clkval) {
		++clkval;
		icmpclk();
		tick();
		(void) iss();
	}
}
