/* 
 *  A collection of amd functions for use with amd.c amd sploit.
 *  This is derived from the amd/include files.
 *
 *  -- anathema
 */


typedef char *aqs;
typedef long *ttype;
typedef struct amq_mount_tree amq_mount_tree;
typedef amq_mount_tree *amq_mount_tree_p;

struct
amq_mount_tree
{
    aqs mt_mountinfo;
    aqs mt_directory;
    aqs mt_mountpoint;
    aqs mt_type;
    ttype mt_mounttime;
    u_short mt_mountuid;
    int mt_getattr;
    int mt_lookup;
    int mt_readdir;
    int mt_readlink;
    int mt_statfs;
    amq_mount_tree *mt_next;
    amq_mount_tree *mt_cld;
};

bool_t xdr_amq_string (XDR *xdrs, aqs *obj)
{
    if (!xdr_string(xdrs,obj,1024)) return(FALSE);
    return TRUE;
}

bool_t xdr_time_type (XDR *xdrs, ttype *obj)
{
    if (!xdr_long(xdrs,(long*)obj)) return FALSE;
    return TRUE;
}

void
amqproc_mount_1 (void *argp, CLIENT *clnt)
{
    static struct timeval timez = {15, 0};               /* timeout delay */
    unsigned long amqproc_mount = 7;
    int resu;
    
    memset((char *)&resu, 0, sizeof(resu));
    
    clnt_call(clnt, amqproc_mount, (xdrproc_t)xdr_amq_string, argp,
	    (xdrproc_t)xdr_int, (caddr_t)&resu, timez);
}
    
/* EOF */  
