/* creates mhosts.h for the server */

#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

unsigned long int
lookup (char *hostname)
{
  struct hostent *name;
  unsigned long int address;

  if ((address = inet_addr (hostname)) != -1)
    return address;
  if ((name = gethostbyname (hostname)) == NULL)
    return 0;

  memcpy (&address, name->h_addr, name->h_length);
  return address;
}

int verror(char *et)
{
    printf("ERROR: %s\n",et);
    exit(0x1);
}


int main(int argc,char **argv) 
{
 char ipin[200];
 int ip1,ip2;
 FILE *pwh;

 printf("-Pre-Compilation----------------------\n");
 printf("enter the master host 1 : ");
 if(fgets(ipin,sizeof(ipin),stdin)==NULL)
     verror("No Input");
 ip1=lookup(ipin);
 if(ip1==0)
     verror("cannot resolve Host");
 printf("enter the master host 2 : ");
 if(fgets(ipin,sizeof(ipin),stdin)==NULL)
     verror("No Input");
 ip2=lookup(ipin);
 fflush(stdout);
 printf("--------------------------------------\n");
 if((pwh=fopen("mhosts.h","w"))==NULL)
 {
     printf("Cannot open mhosts.h, aborting\n");
     exit(0x1);
 }
 fprintf(pwh,"/* master hosts */\n\n");
 fprintf(pwh,"#define MSERVER1 %i\n#define MSERVER2 %i\n",ip1,ip2);
 fclose(pwh);
 printf("mhosts.h created..\n");      
 exit(0x0);
}

