/* tool-a.c
 *
 * v1.1 (c) 21/05/2000 codex@bogus.net
 *
 *        ++ big greetings ++   maelstrom and fake   ++ big greetingss ++
 *
 * greetings to the spies team; you know who you are. hi to sluggo. may your
 * palm crash even though i am not around to do it for you. hehe.
 *
 * this code is based on the sessionwall stuff, which should be found on 
 * http://www.phate.net
 *
 */

#define BUFSIZE 256
#define TOOL_DATASIZE 184
#define MSG_START 20
#define TCP_START LIBNET_ETH_H+LIBNET_IP_H
#define DATA_START TCP_START+LIBNET_TCP_H
#define SNAPLEN LIBNET_IP_H+LIBNET_TCP_H+TOOL_DATASIZE  /* bytes to capture */ 

#ifndef DEBUG
#define DEBUG 1
#endif

#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <pcap/pcap.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <libnet.h>

#ifdef LINUX
#include <linux/socket.h>
#include <linux/inet.h>
#else
#include <sys/socket.h>
#include <arpa/inet.h>
#endif


/* DecodePacket -- decodes captured packet --------------------------------- */

void DecodePacket(char *packet,unsigned short our_id) {

  int count,lc,ver;

  unsigned char byte;
  unsigned char sip[4];  /* source ip address */
  unsigned char dip[4];  /* destination ip address */

  if(DEBUG) {fprintf(stdout,"\n");}

  /* grab some stuff from the IP header */

  memcpy(&dip,&packet[26],4);
  memcpy(&sip,&packet[30],4);

  if(DEBUG) {

    /* source address */

    fprintf(stdout,"%d.%d.%d.%d -> ",
	    (unsigned char)dip[0],
	    (unsigned char)dip[1],
	    (unsigned char)dip[2],
	    (unsigned char)dip[3]);

    /* destination address */

    fprintf(stdout,"%d.%d.%d.%d ",
	    (unsigned char)sip[0],
	    (unsigned char)sip[1],
	    (unsigned char)sip[2],
	    (unsigned char)sip[3]);

  }

  /* if debug, print captured packet */

  if(DEBUG) {

    fprintf(stdout,"\n");

    lc=0;

    for(count=0;count<SNAPLEN;count++) {
      fprintf(stdout,"%02x ",(unsigned char)packet[count]);
      lc++;
      if(lc>15) {
	lc=0;
	fprintf(stdout,"\n");
      }
    }
  }

  /* is it for us? (ACK etc) */

  if(!memcmp(&packet[DATA_START],"TOOL",4) && packet[TCP_START+13]==0x10) {

    /* print incoming message */

    fprintf(stdout,"%s",&packet[DATA_START+MSG_START]);

  }
}



void usage(void) {
      fprintf(stdout,"usage: tool-a [-h] [-i <device>]\n");
      fprintf(stdout,"\t -h : this\n");
      fprintf(stdout,"\t -i : network device (default eth0)\n");
}

/* main() -- the big kahuna ------------------------------------------------ */

int main(int argc, char *argv[]) {

  pcap_t *pd;                      /* capture device descriptor */

  char errbuf[PCAP_ERRBUF_SIZE];   /* pcap's error buffer */
  char buffer[BUFSIZE];            /* buffer to store data in */ 
  char device[BUFSIZE];                /* capture device */

  char *filter_spec = "tcp[13:1]=0x10";  /* tcp pkts w/ack set only */

  /* char *filter_spec = NULL;  */

  int timeout = 180;               /* read timeout in ms */
  int promisc = 1;                 /* put the i/f into promisc mode */
  int optimize = 0;                /* no optimising */

  int int_foo,c; /* dummy ints */

  unsigned short id;

  unsigned char *p_ptr;            /* pointer to captured packet */

  struct pcap_pkthdr pkt_header;
  struct bpf_program filter_code;

  bpf_u_int32 network,netmask;

  srand(getpid());

  bzero(device,sizeof(device));

  while((c = getopt(argc,argv,"i:h")) != EOF) {
    switch(c) {
    case 'i':
      if(sizeof(optarg)<sizeof(device)) memcpy(device,optarg,sizeof(optarg));
      break;
    case 'h':
      usage();
      exit(0);
    }
  }

  if(!device[0]) {
    fprintf(stderr,"ERROR: no listening device!\n");
    exit(1);
  }

  /* get packet capture descriptor, exit & fail if not */

  bzero(buffer,sizeof(buffer));

  if(!(pd = pcap_open_live(device,SNAPLEN,promisc,timeout,buffer))) {
    fprintf(stderr,"Couldn't open device %s: %s (root privs?)\n",
	    device,strerror(errno));
    exit(1);
  }

  /* lookup & set network details */

  if(pcap_lookupnet(device,&network,&netmask,errbuf)<0) {
    fprintf(stderr,"Couldn't get network details: %s\n",errbuf);
    exit(1);
  };

  /* compile filter spec */

  if(pcap_compile(pd,&filter_code,filter_spec,optimize,netmask)<0) {
    fprintf(stderr,"Couldn't compile filter: %s\n",pcap_geterr(pd));
    exit(1);
  }

  /* use filter */

  if(pcap_setfilter(pd,&filter_code)<0) {
    fprintf(stderr,"Failed to set filter: %s\n",pcap_geterr(pd));
    exit(1);
  }

  id=rand()%0xffff;

  /* decode detected packet buffer, do so forever */

  fprintf(stdout,"Waiting for TOOL packets...\n");

  while(((char *)p_ptr=pcap_next(pd,&pkt_header))>0) {
    DecodePacket(p_ptr,id);
    if(DEBUG) {fprintf(stdout,"\n");}
    fflush(stdout);
  }

  /* close descriptor; currently we never get here, so this is bad code :) */

  pcap_close(pd);

  return(0); /* all is well */

}











