DECLARE SUB newsession ()
DECLARE SUB editsession ()
DECLARE SUB savesession ()
DECLARE SUB loadsession ()
DECLARE SUB sessions ()
DECLARE SUB editpattern ()
DECLARE SUB savepattern ()
DECLARE SUB newpattern ()
DECLARE SUB loadpattern ()
DECLARE SUB patterns ()
DECLARE SUB doit ()
DECLARE SUB options ()
DECLARE SUB mainmenu ()
DECLARE SUB intro ()
COMMON SHARED patternset%, patternname$, port%, frames%, soundtog%, soundfreq%, speed%, speed2%, speed3%, cablemode%, sessionset%, sessionname$, sessionframes%, sessiontotal%
' $DYNAMIC
DIM SHARED pattern(2, 8) '(frames, LED's 1-8)
DIM SHARED session(3, 2)'(frames, (length, hertz))
speed% = 5
speed2% = 5
speed3% = 5
port% = 888
soundfreq% = 300
patternset% = 0
sessionset% = 0
cablemode% = 0
OUT port%, 255

SCREEN 9
CLS
CALL intro
CALL mainmenu

IF cablemode% = 1 THEN OUT port%, 255
IF cablemode% = 0 THEN OUT port%, 0

REM $STATIC
SUB doit
SCREEN 9
CLS
IF sessionset% = 0 THEN curr% = 1
IF sessionset% = 1 THEN curr% = 4
currframe% = 1
currsessionframe% = 1
currspeed% = 5
origtimer! = TIMER

frameminutesleft% = session(1, 1)
frameminuteselapsed% = 0
frametimer! = TIMER

DO
CLS
LOCATE 1, 1
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT "Current pattern: "; patternname$; ", Frame #"; currframe%
PRINT "Current Session: "; sessionname$
PRINT "Elapsed minutes: "; elapsedminutes%; " Elapsed seconds: "; elapsedseconds%
PRINT "Press 'x' to end"
PRINT
LOCATE 8, 1
PRINT "  SPEED (1):"; speed%
PRINT "  SPEED (2):"; speed2%
PRINT "  SPEED (3):"; speed3%

LINE (150, 100)-(150 + speed%, 110), 14, BF
LINE (150, 113)-(150 + speed2%, 123), 14, BF
LINE (150, 126)-(150 + speed3%, 136), 14, BF

elapsedseconds% = INT(TIMER - origtimer!)
elapsedminutes% = INT(elapsedseconds% / 60)
 
IF sessionset% = 1 THEN
PRINT "  Session: "; session(currsessionframe%, 2); "Hz."
LINE (150, 139)-(150 + INT(elapsedseconds% / 60), 142), 15, BF
LINE (150, 144)-(150 + (sessiontotal%), 147), 14, BF
FOR i% = 1 TO sessionframes%
sessiondraw% = sessiondraw% + (session(i%, 1))
IF sessiontotal% >= 10 THEN LINE (150 + sessiondraw%, 144)-(150 + sessiondraw%, 147), 0, BF
NEXT i%

IF frameminuteselapsed% >= frameminutesleft% THEN
currsessionframe% = currsessionframe% + 1
frameminutesleft% = session(currsessionframe%, 1)
frametimer! = TIMER
END IF
frameminuteselapsed% = INT((TIMER - frametimer!) / 60)

IF curr% = 4 THEN currspeed% = session(currsessionframe%, 2)

END IF
sessiondraw% = 0

LOCATE (7 + curr%), 1
PRINT ">"

LOCATE 17, 5
IF pattern(currframe%, 1) = 1 THEN COLOR 4:                   ELSE COLOR 15
PRINT "1"
LOCATE 18, 3
IF pattern(currframe%, 4) = 1 THEN COLOR 4:                     ELSE COLOR 15
PRINT "4"
LOCATE 18, 7
IF pattern(currframe%, 2) = 1 THEN COLOR 4:                     ELSE COLOR 15
PRINT "2"
LOCATE 19, 5
IF pattern(currframe%, 3) = 1 THEN COLOR 4:                     ELSE COLOR 15
PRINT "3"

LOCATE 17, 15
IF pattern(currframe%, 5) = 1 THEN COLOR 4:                     ELSE COLOR 15
PRINT "5"
LOCATE 18, 13
IF pattern(currframe%, 8) = 1 THEN COLOR 4:                       ELSE COLOR 15
PRINT "8"
LOCATE 18, 17
IF pattern(currframe%, 6) = 1 THEN COLOR 4:                       ELSE COLOR 15
PRINT "6"
LOCATE 19, 15
IF pattern(currframe%, 7) = 1 THEN COLOR 4:                       ELSE COLOR 15
PRINT "7"


COLOR 15

DO
h$ = INKEY$
IF TIMER >= stimer! + (1 / currspeed%) THEN
flip% = 1
EXIT DO
END IF
LOOP UNTIL h$ <> ""

IF flip% = 1 THEN
stimer! = TIMER
flip% = 0
currframe% = currframe% + 1
IF currframe% > frames% THEN currframe% = 1
IF cablemode% = 1 THEN toout% = 255
IF cablemode% = 0 THEN toout% = 0
IF cablemode% = 1 THEN
IF pattern(currframe%, 1) = 1 THEN toout% = toout% - 1
IF pattern(currframe%, 2) = 1 THEN toout% = toout% - 2
IF pattern(currframe%, 3) = 1 THEN toout% = toout% - 4
IF pattern(currframe%, 4) = 1 THEN toout% = toout% - 8
IF pattern(currframe%, 5) = 1 THEN toout% = toout% - 16
IF pattern(currframe%, 6) = 1 THEN toout% = toout% - 32
IF pattern(currframe%, 7) = 1 THEN toout% = toout% - 64
IF pattern(currframe%, 8) = 1 THEN toout% = toout% - 128
END IF
IF cablemode% = 0 THEN
IF pattern(currframe%, 1) = 1 THEN toout% = toout% + 1
IF pattern(currframe%, 2) = 1 THEN toout% = toout% + 2
IF pattern(currframe%, 3) = 1 THEN toout% = toout% + 4
IF pattern(currframe%, 4) = 1 THEN toout% = toout% + 8
IF pattern(currframe%, 5) = 1 THEN toout% = toout% + 16
IF pattern(currframe%, 6) = 1 THEN toout% = toout% + 32
IF pattern(currframe%, 7) = 1 THEN toout% = toout% + 64
IF pattern(currframe%, 8) = 1 THEN toout% = toout% + 128
END IF

OUT port%, toout%

IF soundtog% = 1 THEN SOUND (soundfreq%), .1

END IF


IF MID$(h$, 2, 1) = "M" THEN 'right
IF curr% = 1 THEN speed% = speed% + 1
IF curr% = 2 THEN speed2% = speed2% + 1
IF curr% = 3 THEN speed3% = speed3% + 1
END IF
IF MID$(h$, 2, 1) = "K" THEN 'left
IF curr% = 1 THEN speed% = speed% - 1
IF curr% = 2 THEN speed2% = speed2% - 1
IF curr% = 3 THEN speed3% = speed3% - 1
END IF
IF MID$(h$, 2, 1) = "H" THEN 'up
curr% = curr% - 1
END IF
IF MID$(h$, 2, 1) = "P" THEN 'down
curr% = curr% + 1
END IF

IF sessionset% = 1 THEN IF curr% > 4 THEN curr% = 4
IF sessionset% = 0 THEN IF curr% > 3 THEN curr% = 3
IF curr% < 1 THEN curr% = 1

IF speed% <= 0 THEN speed% = 1
IF speed2% <= 0 THEN speed2% = 1
IF speed3% <= 0 THEN speed3% = 1
IF speed% > 100 THEN speed% = 100
IF speed2% > 100 THEN speed2% = 100
IF speed3% > 100 THEN speed3% = 100

IF curr% = 1 THEN currspeed% = speed%
IF curr% = 2 THEN currspeed% = speed2%
IF curr% = 3 THEN currspeed% = speed3%

IF sessionset% = 1 THEN
IF elapsedminutes% >= sessiontotal% THEN
CLS
PRINT
PRINT "Session: "; sessionname$; " complete!"
DO: LOOP UNTIL INKEY$ <> ""
EXIT DO
END IF
END IF

LOOP UNTIL LCASE$(h$) = "x"

IF cablemode% = 1 THEN OUT port%, 255
IF cablemode% = 0 THEN OUT port%, 0

END SUB

SUB editpattern
SCREEN 9
CLS
COLOR 15
CLS
patternset% = 1
patternname$ = "Unsaved Pattern"
currframe% = 1
DO
CLS
LOCATE 1, 1
PRINT "+/- Change Current Frame   123...8 Toggles the LED on the current frame."
PRINT "'x' saves your pattern."
PRINT "Current Frame: "; currframe%; " out of "; frames%; " frames."

LOCATE 5, 5
IF pattern(currframe%, 1) = 1 THEN COLOR 4:                 ELSE COLOR 15
PRINT "1"
LOCATE 6, 3
IF pattern(currframe%, 4) = 1 THEN COLOR 4:                   ELSE COLOR 15
PRINT "4"
LOCATE 6, 7
IF pattern(currframe%, 2) = 1 THEN COLOR 4:                   ELSE COLOR 15
PRINT "2"
LOCATE 7, 5
IF pattern(currframe%, 3) = 1 THEN COLOR 4:                   ELSE COLOR 15
PRINT "3"

LOCATE 5, 15
IF pattern(currframe%, 5) = 1 THEN COLOR 4:                   ELSE COLOR 15
PRINT "5"
LOCATE 6, 13
IF pattern(currframe%, 8) = 1 THEN COLOR 4:                     ELSE COLOR 15
PRINT "8"
LOCATE 6, 17
IF pattern(currframe%, 6) = 1 THEN COLOR 4:                     ELSE COLOR 15
PRINT "6"
LOCATE 7, 15
IF pattern(currframe%, 7) = 1 THEN COLOR 4:                     ELSE COLOR 15
PRINT "7"


COLOR 15

DO
h$ = INKEY$
LOOP UNTIL h$ <> ""

IF h$ = "=" OR h$ = "+" THEN
currframe% = currframe% + 1
IF currframe% > frames% THEN currframe% = currframe% - 1
END IF

IF h$ = "-" OR h$ = "_" THEN
currframe% = currframe% - 1
IF currframe% = 0 THEN currframe% = currframe% + 1
END IF

IF h$ = "1" THEN : IF pattern(currframe%, 1) = 1 THEN pattern(currframe%, 1) = 0:               ELSE pattern(currframe%, 1) = 1
IF h$ = "2" THEN : IF pattern(currframe%, 2) = 1 THEN pattern(currframe%, 2) = 0:               ELSE pattern(currframe%, 2) = 1
IF h$ = "3" THEN : IF pattern(currframe%, 3) = 1 THEN pattern(currframe%, 3) = 0:               ELSE pattern(currframe%, 3) = 1
IF h$ = "4" THEN : IF pattern(currframe%, 4) = 1 THEN pattern(currframe%, 4) = 0:               ELSE pattern(currframe%, 4) = 1
IF h$ = "5" THEN : IF pattern(currframe%, 5) = 1 THEN pattern(currframe%, 5) = 0:               ELSE pattern(currframe%, 5) = 1
IF h$ = "6" THEN : IF pattern(currframe%, 6) = 1 THEN pattern(currframe%, 6) = 0:               ELSE pattern(currframe%, 6) = 1
IF h$ = "7" THEN : IF pattern(currframe%, 7) = 1 THEN pattern(currframe%, 7) = 0:               ELSE pattern(currframe%, 7) = 1
IF h$ = "8" THEN : IF pattern(currframe%, 8) = 1 THEN pattern(currframe%, 8) = 0:               ELSE pattern(currframe%, 8) = 1


IF LCASE$(h$) = "x" THEN EXIT DO

LOOP

END SUB

SUB editsession
sessionset% = 1
sessionname$ = "Unsaved session"
currframe% = 1

sessiontotal% = 0
FOR i% = 1 TO sessionframes%
sessiontotal% = sessiontotal% + session(i%, 1)
NEXT i%

DO
CLS
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT
PRINT "Session Edit"
PRINT "+/- to change frames   'x' to return to menu"
PRINT
PRINT "Current Frame: "; currframe%; " of "; sessionframes%
PRINT
PRINT "l-----Length (minutes):  "; session(currframe%, 1)
PRINT "h-----Hertz:             "; session(currframe%, 2)

LINE (150, 144)-(150 + (sessiontotal%), 147), 14, BF
FOR i% = 1 TO sessionframes%
sessiondraw% = sessiondraw% + (session(i%, 1))
IF sessiontotal% >= 10 THEN LINE (150 + sessiondraw%, 144)-(150 + sessiondraw%, 147), 0, BF
NEXT i%
sessiondraw% = 0

DO
h$ = INKEY$
LOOP UNTIL h$ <> ""
IF h$ = "=" OR h$ = "+" THEN currframe% = currframe% + 1
IF h$ = "_" OR h$ = "-" THEN currframe% = currframe% - 1
IF LCASE$(h$) = "l" THEN
DO
INPUT "Length? ", tlength%
LOOP UNTIL tlength% > 0
tlength% = INT(tlength%)
session(currframe%, 1) = tlength%
END IF
IF LCASE$(h$) = "h" THEN
DO
INPUT "Hertz? ", thertz%
LOOP UNTIL thertz% > 0
tlength% = INT(thertz%)
session(currframe%, 2) = thertz%
END IF

sessiontotal% = 0
FOR i% = 1 TO sessionframes%
sessiontotal% = sessiontotal% + session(i%, 1)
NEXT i%

IF currframe% < 1 THEN currframe% = 1
IF currframe% > sessionframes% THEN currframe% = sessionframes%
LOOP UNTIL LCASE$(h$) = "x"
END SUB

SUB intro
SCREEN 9
CLS
COLOR 12
PRINT
PRINT "HardCore Software Presents..."
PRINT
COLOR 13
PRINT "Brainstar 1: A featured application for the BrainWave"
PRINT "Machine (machine design by CYB0RG/ASM from www.hackcanada.com)"
PRINT
DO: LOOP UNTIL INKEY$ <> ""
END SUB

SUB loadpattern
SCREEN 9
CLS
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT
PRINT "Load Pattern"
PRINT
PRINT "Pattern to load? (Include any paths)"
INPUT "", filename$
PRINT "Loading..."
patternname$ = filename$
patternset% = 1
OPEN filename$ FOR INPUT AS #1
INPUT #1, frames%
REDIM pattern(frames%, 8)
FOR i% = 1 TO frames%
FOR g% = 1 TO 8
INPUT #1, pattern(i%, g%)
NEXT g%
NEXT i%
CLOSE #1
PRINT
PRINT "File Loaded."
PRINT
PRINT "Press any key to continue..."
DO: LOOP UNTIL INKEY$ <> ""

END SUB

SUB loadsession
SCREEN 9
CLS
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT
PRINT "Load Session"
PRINT
INPUT "Filename? (Include any paths)? ", filename$
sessionname$ = filename$
sessionset% = 1
PRINT
PRINT "Loading..."
OPEN filename$ FOR INPUT AS #1
INPUT #1, sessionframes%, sessiontotal%
REDIM session(sessionframes%, 2)
FOR i% = 1 TO sessionframes%
INPUT #1, session(i%, 1)
INPUT #1, session(i%, 2)
NEXT i%
CLOSE #1
PRINT "File loaded..."
DO: LOOP UNTIL INKEY$ <> ""

END SUB

SUB mainmenu
SCREEN 9
DO
CLS
COLOR 13
PRINT
PRINT "Brainstar 1: By HardCore Software"
PRINT
COLOR 15
IF patternset% = 0 THEN PRINT "You currently have no pattern selected..."
IF patternset% = 1 THEN PRINT "Your selected pattern is "; patternname$
IF sessionset% = 0 THEN PRINT "You currently have no session selected..."
IF sessionset% = 1 THEN PRINT "Your selected pattern is "; sessionname$
PRINT
COLOR 12
PRINT
PRINT "Main Menu:"
PRINT
PRINT "1----------Set a Pattern"
PRINT "2----------Set a Session"
PRINT "3----------GO"
PRINT "4----------Options"
PRINT "5----------Exit"
PRINT
DO
h$ = INKEY$
LOOP UNTIL h$ <> ""
IF LCASE$(h$) = "1" THEN CALL patterns
IF LCASE$(h$) = "2" THEN CALL sessions
IF LCASE$(h$) = "3" THEN
IF patternset% <> 0 THEN
CALL doit
ELSE
CLS
PRINT
PRINT "You haven't selected a pattern yet..."
DO: LOOP UNTIL INKEY$ <> ""
END IF
END IF
IF LCASE$(h$) = "4" THEN CALL options
IF LCASE$(h$) = "5" OR LCASE$(h$) = "x" THEN EXIT DO
LOOP
COLOR 15
END SUB

SUB newpattern
SCREEN 9
CLS
COLOR 15
PRINT
PRINT "Create a new Brainstar 1 pattern:"
PRINT
DO
PRINT "How many frames do you want your pattern to be?"
INPUT "?", frames%
LOOP UNTIL frames% > 0
frames% = INT(frames%)
CLS
patternset% = 1
patternname$ = "Unsaved Pattern"
REDIM pattern(frames%, 8)
currframe% = 1
DO
CLS
LOCATE 1, 1
PRINT "+/- Change Current Frame   123...8 Toggles the LED on the current frame."
PRINT "'x' saves your pattern."
PRINT "Current Frame: "; currframe%; " out of "; frames%; " frames."

LOCATE 5, 5
IF pattern(currframe%, 1) = 1 THEN COLOR 4:                ELSE COLOR 15
PRINT "1"
LOCATE 6, 3
IF pattern(currframe%, 4) = 1 THEN COLOR 4:                  ELSE COLOR 15
PRINT "4"
LOCATE 6, 7
IF pattern(currframe%, 2) = 1 THEN COLOR 4:                  ELSE COLOR 15
PRINT "2"
LOCATE 7, 5
IF pattern(currframe%, 3) = 1 THEN COLOR 4:                  ELSE COLOR 15
PRINT "3"

LOCATE 5, 15
IF pattern(currframe%, 5) = 1 THEN COLOR 4:                  ELSE COLOR 15
PRINT "5"
LOCATE 6, 13
IF pattern(currframe%, 8) = 1 THEN COLOR 4:                    ELSE COLOR 15
PRINT "8"
LOCATE 6, 17
IF pattern(currframe%, 6) = 1 THEN COLOR 4:                    ELSE COLOR 15
PRINT "6"
LOCATE 7, 15
IF pattern(currframe%, 7) = 1 THEN COLOR 4:                    ELSE COLOR 15
PRINT "7"


COLOR 15

DO
h$ = INKEY$
LOOP UNTIL h$ <> ""

IF h$ = "=" OR h$ = "+" THEN
currframe% = currframe% + 1
IF currframe% > frames% THEN currframe% = currframe% - 1
END IF

IF h$ = "-" OR h$ = "_" THEN
currframe% = currframe% - 1
IF currframe% = 0 THEN currframe% = currframe% + 1
END IF

IF h$ = "1" THEN : IF pattern(currframe%, 1) = 1 THEN pattern(currframe%, 1) = 0:              ELSE pattern(currframe%, 1) = 1
IF h$ = "2" THEN : IF pattern(currframe%, 2) = 1 THEN pattern(currframe%, 2) = 0:              ELSE pattern(currframe%, 2) = 1
IF h$ = "3" THEN : IF pattern(currframe%, 3) = 1 THEN pattern(currframe%, 3) = 0:              ELSE pattern(currframe%, 3) = 1
IF h$ = "4" THEN : IF pattern(currframe%, 4) = 1 THEN pattern(currframe%, 4) = 0:              ELSE pattern(currframe%, 4) = 1
IF h$ = "5" THEN : IF pattern(currframe%, 5) = 1 THEN pattern(currframe%, 5) = 0:              ELSE pattern(currframe%, 5) = 1
IF h$ = "6" THEN : IF pattern(currframe%, 6) = 1 THEN pattern(currframe%, 6) = 0:              ELSE pattern(currframe%, 6) = 1
IF h$ = "7" THEN : IF pattern(currframe%, 7) = 1 THEN pattern(currframe%, 7) = 0:              ELSE pattern(currframe%, 7) = 1
IF h$ = "8" THEN : IF pattern(currframe%, 8) = 1 THEN pattern(currframe%, 8) = 0:              ELSE pattern(currframe%, 8) = 1


IF LCASE$(h$) = "x" THEN EXIT DO

LOOP

END SUB

SUB newsession
currframe% = 1
SCREEN 9
CLS
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT
DO
INPUT "How many session frames? ", sessionframes%
LOOP UNTIL sessionframes% > 0 AND sessionframes% <= 100
sessionframes% = INT(sessionframes%)
sessionset% = 1
sessionname$ = "Unsaved session"
REDIM session(sessionframes%, 2)
DO
CLS
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT
PRINT "Session Edit"
PRINT "+/- to change frames   'x' to return to menu"
PRINT
PRINT "Current Frame: "; currframe%; " of "; sessionframes%
PRINT
PRINT "l-----Length (minutes):  "; session(currframe%, 1)
PRINT "h-----Hertz:             "; session(currframe%, 2)

LINE (150, 144)-(150 + (sessiontotal%), 147), 14, BF
FOR i% = 1 TO sessionframes%
sessiondraw% = sessiondraw% + (session(i%, 1))
IF sessiontotal% >= 10 THEN LINE (150 + sessiondraw%, 144)-(150 + sessiondraw%, 147), 0, BF
NEXT i%
sessiondraw% = 0

DO
h$ = INKEY$
LOOP UNTIL h$ <> ""
IF h$ = "=" OR h$ = "+" THEN currframe% = currframe% + 1
IF h$ = "_" OR h$ = "-" THEN currframe% = currframe% - 1
IF LCASE$(h$) = "l" THEN
DO
INPUT "Length? ", tlength%
LOOP UNTIL tlength% > 0
tlength% = INT(tlength%)
session(currframe%, 1) = tlength%
END IF
IF LCASE$(h$) = "h" THEN
DO
INPUT "Hertz? ", thertz%
LOOP UNTIL thertz% > 0
tlength% = INT(thertz%)
session(currframe%, 2) = thertz%
END IF

sessiontotal% = 0
FOR i% = 1 TO sessionframes%
sessiontotal% = sessiontotal% + session(i%, 1)
NEXT i%

IF currframe% < 1 THEN currframe% = 1
IF currframe% > sessionframes% THEN currframe% = sessionframes%
LOOP UNTIL LCASE$(h$) = "x"
CLS
PRINT
FOR i% = 1 TO sessionframes%
sessiontotal% = sessiontotal% + session(i%, 1)
NEXT i%
PRINT "Total session length is: "; sessiontotal%
DO: LOOP UNTIL h$ <> ""
END SUB

SUB options
SCREEN 9
DO
CLS
COLOR 11
PRINT
PRINT "Brainstar 1: By HardCore Software"
PRINT
IF patternset% = 0 THEN PRINT "You currently have no pattern selected..."
IF patternset% = 1 THEN PRINT "Your selected pattern is "; patternname$
IF sessionset% = 0 THEN PRINT "You currently have no session selected..."
IF sessionset% = 1 THEN PRINT "Your selected pattern is "; sessionname$
PRINT
COLOR 13
PRINT
PRINT "Options Menu:"
PRINT
PRINT "1----------New port setting. Current:"; port%; "(in decimal)"
IF soundtog% = 0 THEN soundon$ = "Off"
IF soundtog% = 1 THEN soundon$ = "On"
PRINT "2----------Sound On/Off. Current:"; soundon$
PRINT "3----------Sound Frequency (In hertz). Current:"; soundfreq%
IF cablemode% = 0 THEN PRINT "4----------Normal or Reverse port: Normal"
IF cablemode% = 1 THEN PRINT "4----------Normal or Reverse port: Reverse"
PRINT "5----------Back to main menu"
PRINT
DO
h$ = INKEY$
LOOP UNTIL h$ <> ""
IF LCASE$(h$) = "1" THEN
CLS
PRINT : PRINT "Current port setting is: "; port%; "(In decimal)"
PRINT : PRINT "New setting? (In decimal)?"
INPUT tp%
IF tp% > 0 THEN port% = tp%
tp% = 0
END IF
IF LCASE$(h$) = "2" THEN
CLS
IF soundtog% = 1 THEN
soundtog% = 0
ELSE
soundtog% = 1
END IF
END IF

IF LCASE$(h$) = "3" THEN
CLS
PRINT : PRINT "Current sound frequency setting is: "; soundfreq%
PRINT : PRINT "New setting? (50-5000)?"
INPUT tp%
IF tp% >= 50 AND tp% <= 5000 THEN soundfreq% = INT(tp%)
tp% = 0
END IF

IF LCASE$(h$) = "4" THEN
CLS
IF cablemode% = 1 THEN
cablemode% = 0
ELSE
cablemode% = 1
END IF
END IF

IF LCASE$(h$) = "5" THEN EXIT DO
LOOP UNTIL LCASE$(h$) = "x"

END SUB

SUB patterns
SCREEN 9
DO
CLS
COLOR 13
PRINT
PRINT "Brainstar 1: By HardCore Software"
PRINT
COLOR 12
PRINT
PRINT "Pattern Menu:"
PRINT
COLOR 15
IF patternset% = 0 THEN PRINT "You currently have no pattern selected..."
IF patternset% = 1 THEN PRINT "Your selected pattern is "; patternname$
IF sessionset% = 0 THEN PRINT "You currently have no session selected..."
IF sessionset% = 1 THEN PRINT "Your selected pattern is "; sessionname$
COLOR 12
PRINT
PRINT "PRE-MADE PATTERNS:"
PRINT "s--Solid    f--Flip Flop   c--Chase 1   d--Chase 2"
PRINT "t--Train 1  m--Train 2     o--Sweep 1   i--Sweep 2"
PRINT
PRINT "1----------NEW PATTERN"
PRINT "2----------EDIT PATTERN"
PRINT "3----------SAVE PATTERN"
PRINT "4----------LOAD A PATTERN"
PRINT "5----------Back to Main Menu"
PRINT
DO
h$ = INKEY$
LOOP UNTIL h$ <> ""
IF LCASE$(h$) = "s" THEN
patternname$ = "Solid"
patternset% = 1
frames% = 2
REDIM pattern(frames%, 8)
FOR g% = 1 TO 8
pattern(1, g%) = 0
pattern(2, g%) = 1
NEXT g%
END IF
IF LCASE$(h$) = "f" THEN
patternname$ = "Flip-Flop"
frames% = 2
REDIM pattern(frames%, 8)
patternset% = 1
pattern(1, 4) = 1
pattern(1, 2) = 1
pattern(1, 8) = 1
pattern(1, 6) = 1
pattern(2, 1) = 1
pattern(2, 3) = 1
pattern(2, 5) = 1
pattern(2, 7) = 1
END IF
IF LCASE$(h$) = "c" THEN
patternname$ = "Chase 1"
patternset% = 1
frames% = 4
REDIM pattern(frames%, 8)
pattern(1, 1) = 1
pattern(1, 5) = 1
pattern(2, 6) = 1
pattern(2, 2) = 1
pattern(3, 7) = 1
pattern(3, 3) = 1
pattern(4, 8) = 1
pattern(4, 4) = 1
END IF
IF LCASE$(h$) = "d" THEN
patternname$ = "Chase 2"
patternset% = 1
frames% = 4
REDIM pattern(frames%, 8)
FOR g% = 1 TO frames%
FOR i% = 1 TO 8
pattern(g%, i%) = 1
NEXT i%
NEXT g%
pattern(1, 1) = 0
pattern(1, 5) = 0
pattern(2, 6) = 0
pattern(2, 2) = 0
pattern(3, 7) = 0
pattern(3, 3) = 0
pattern(4, 8) = 0
pattern(4, 4) = 0
END IF
IF LCASE$(h$) = "t" THEN
patternname$ = "Train 1"
patternset% = 1
frames% = 8
REDIM pattern(frames%, 8)
pattern(1, 1) = 1
pattern(2, 5) = 1
pattern(3, 4) = 1
pattern(4, 2) = 1
pattern(5, 8) = 1
pattern(6, 6) = 1
pattern(7, 3) = 1
pattern(8, 7) = 1
END IF
IF LCASE$(h$) = "m" THEN
patternname$ = "Train 2"
patternset% = 1
frames% = 8
REDIM pattern(frames%, 8)
FOR g% = 1 TO frames%
FOR i% = 1 TO 8
pattern(g%, i%) = 1
NEXT i%
NEXT g%
pattern(1, 1) = 0
pattern(2, 5) = 0
pattern(3, 4) = 0
pattern(4, 2) = 0
pattern(5, 8) = 0
pattern(6, 6) = 0
pattern(7, 3) = 0
pattern(8, 7) = 0
END IF
IF LCASE$(h$) = "o" THEN
patternname$ = "Outwards Sweep"
patternset% = 1
frames% = 3
REDIM pattern(frames%, 8)
pattern(1, 2) = 1
pattern(1, 8) = 1
pattern(2, 1) = 1
pattern(2, 3) = 1
pattern(2, 5) = 1
pattern(2, 7) = 1
pattern(3, 6) = 1
pattern(3, 4) = 1
END IF
IF LCASE$(h$) = "i" THEN
patternname$ = "Inwards Sweep"
patternset% = 1
frames% = 3
REDIM pattern(frames%, 8)
pattern(1, 6) = 1
pattern(1, 4) = 1
pattern(2, 1) = 1
pattern(2, 3) = 1
pattern(2, 5) = 1
pattern(2, 7) = 1
pattern(3, 2) = 1
pattern(3, 8) = 1

END IF

IF LCASE$(h$) = "1" THEN CALL newpattern
IF LCASE$(h$) = "2" THEN CALL editpattern
IF LCASE$(h$) = "3" THEN CALL savepattern
IF LCASE$(h$) = "4" THEN CALL loadpattern
IF LCASE$(h$) = "5" THEN EXIT DO
LOOP UNTIL LCASE$(h$) = "x"
COLOR 15
END SUB

SUB savepattern
SCREEN 9
CLS
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT
PRINT "Save Pattern"
PRINT
PRINT "Filename to save current pattern to? (Include any paths)"
INPUT "", filename$
PRINT "Saving..."
patternname$ = filename$
patternset% = 1
OPEN filename$ FOR OUTPUT AS #1
PRINT #1, frames%
FOR i% = 1 TO frames%
FOR g% = 1 TO 8
PRINT #1, pattern(i%, g%)
NEXT g%
NEXT i%
CLOSE #1
PRINT
PRINT "File Saved."
PRINT
PRINT "Press any key to continue..."
DO: LOOP UNTIL INKEY$ <> ""
END SUB

SUB savesession
SCREEN 9
CLS
PRINT
PRINT "Brainstar 1: HardCore Software"
PRINT
PRINT "Save Session"
PRINT
INPUT "Filename? (Include any paths)? ", filename$
sessionname$ = filename$
sessionset% = 1
PRINT
PRINT "Saving..."
OPEN filename$ FOR OUTPUT AS #1
PRINT #1, sessionframes%, sessiontotal%
FOR i% = 1 TO sessionframes%
PRINT #1, session(i%, 1)
PRINT #1, session(i%, 2)
NEXT i%
CLOSE #1
PRINT "File saved..."
DO: LOOP UNTIL INKEY$ <> ""
END SUB

SUB sessions
SCREEN 9
DO
CLS
COLOR 13
PRINT
PRINT "Brainstar 1: By HardCore Software"
PRINT
COLOR 12
PRINT
PRINT "Sessions Menu:"
PRINT
COLOR 15
IF patternset% = 0 THEN PRINT "You currently have no pattern selected..."
IF patternset% = 1 THEN PRINT "Your selected pattern is "; patternname$
IF sessionset% = 0 THEN PRINT "You currently have no session selected..."
IF sessionset% = 1 THEN PRINT "Your selected pattern is "; sessionname$
COLOR 12
PRINT
PRINT "PRE-MADE SESSIONS:"
PRINT "s--20 Minutes sleep inducer   n--Hour and a half nap "
PRINT "b--10 minute booster          w--Wake up (15 minutes)"
PRINT
PRINT "1----------NEW SESSION"
PRINT "2----------EDIT SESSION"
PRINT "3----------SAVE SESSION"
PRINT "4----------LOAD A SESSION"
PRINT "5----------Back to Main Menu"
PRINT
DO
h$ = INKEY$
LOOP UNTIL h$ <> ""
IF LCASE$(h$) = "s" THEN
sessionset% = 1
sessionframes% = 4
sessionname$ = "20 Minutes sleep inducer"
REDIM session(4, 2)
session(1, 1) = 5
session(2, 1) = 5
session(3, 1) = 5
session(4, 1) = 5
sessiontotal% = 20
session(1, 2) = 12
session(2, 2) = 9
session(3, 2) = 7
session(4, 2) = 4
END IF
IF LCASE$(h$) = "n" THEN
sessionset% = 1
sessionframes% = 7
sessionname$ = "Hour and a half nap"
REDIM session(7, 2)
session(1, 1) = 5
session(2, 1) = 5
session(3, 1) = 5
session(4, 1) = 60
session(5, 1) = 5
session(6, 1) = 5
session(7, 1) = 5
sessiontotal% = 90
session(1, 2) = 12
session(2, 2) = 9
session(3, 2) = 7
session(4, 2) = 4
session(5, 2) = 7
session(6, 2) = 9
session(7, 2) = 12
END IF
IF LCASE$(h$) = "b" THEN
sessionset% = 1
sessionframes% = 4
sessionname$ = "10 minute Booster"
REDIM session(4, 2)
session(1, 1) = 2
session(2, 1) = 2
session(3, 1) = 2
session(4, 1) = 4
sessiontotal% = 10
session(1, 2) = 12
session(2, 2) = 14
session(3, 2) = 16
session(4, 2) = 18
END IF
IF LCASE$(h$) = "w" THEN
sessionset% = 1
sessionframes% = 4
sessionname$ = "Wake up (15 minutes)"
REDIM session(4, 2)
session(1, 1) = 2
session(2, 1) = 2
session(3, 1) = 5
session(4, 1) = 6
sessiontotal% = 15
session(1, 2) = 7
session(2, 2) = 9
session(3, 2) = 12
session(4, 2) = 14
END IF

IF LCASE$(h$) = "1" THEN CALL newsession
IF LCASE$(h$) = "2" THEN CALL editsession
IF LCASE$(h$) = "3" THEN CALL savesession
IF LCASE$(h$) = "4" THEN CALL loadsession
IF LCASE$(h$) = "5" THEN EXIT DO
LOOP UNTIL h$ = "x"
END SUB

