
#include	"meskalin.hpp"




int main(int argc, char *argv[])
{
int frequency = 10;
char *pattern;
char *special;
char *pattern_opt;
char *special_opt;
char pattern_opt_default[] = "none";
char special_opt_default[] = "none";

	for(int i=1; argc>i; i++)
	{
	//printf("argument: %s\n", argv[i]); //dbug
		if(argv[i][0]=='-')
		{
			switch(argv[i][1])
			{
				case 'h':
				{
					meskalin.usage(argv[0]);
					break;
				}

				case 'f':
				{
					frequency = meskalin.getint(argv[i+1]);
					break;
				}

				case 'g':
				{
					frequency = meskalin.getfreq(argv[i+1]);
					break;
				}

				case 'p':
				{
					pattern = argv[i+1];
						if ((argc-i)<2) {
						meskalin.usage(argv[0]);
						}
						if ((argc-i)>2) {
						pattern_opt = argv[i+2];
						} else {
						pattern_opt = pattern_opt_default;
						}
						//printf("argc: %i, i: %i\n", argc, i);
					break;
				}
				case 's':
				{
					special = argv[i+1];
						if ((argc-i)<2) {
						meskalin.usage(argv[0]);
						}
						if ((argc-i)>2) {
						special_opt = argv[i+2];
						} else {
						special_opt = special_opt_default;
						}
					break;
				}

			}
			//printf("switched to: %c\n", argv[i][1]);
		}
	}

	//printf("frequency: %i\npattern: %s\n", frequency, pattern);


	if(strcmp(special, "reset")==0)		meskalin.reset();
	if(strcmp(special, "freqvar")==0)	meskalin.freqvar(special_opt, pattern);
	if(strcmp(special, "address")==0)	meskalin.address(meskalin.getint(special_opt));
	if(strcmp(special, "led")==0)		meskalin.led(meskalin.getint(special_opt));

	if(strcmp(pattern, "normal")==0)	meskalin.normal(frequency);
	if(strcmp(pattern, "flipflop")==0)	meskalin.flipflop(frequency);
	if(strcmp(pattern, "chasing")==0)	meskalin.chasing(frequency, pattern_opt);
	if(strcmp(pattern, "windowlicker")==0)	meskalin.windowlicker(frequency, pattern_opt);
	else 					meskalin.normal(frequency);
}

void meskalin::usage(char *self)
{
printf("

	MESKALIN v1.2
	by:	dodo [dodo@fuckmicrosoft.com]
	url:	http://darkwired.ath.cx/projects/meskalin/

	// parport LED control software
	// \'the future of your mind relies on wetwire\'

	thnx to:	tsunami

usage:
	%s [options]
	-h	show this
	-f	frequency
	-g	frequency group:
		[delta|theta|alpha|lowbeta|midbeta|highbeta|gamma]
	-p	output pattern:
		normal
		chasing		[clockwise|anticlockwise|wacky|wacky_reverse]
		flipflop
		windowlicker	[reverse|inwards|outwards]
	-s	special functions:
		reset
		address	<decimal address>	sends \'1\' to the decimal address
		led	<LED>			turns on <LED>

", self);
exit(1);
}

int meskalin::getfreq(char *group)
{
if (strcmp(group, "delta")==0)		return 2;
if (strcmp(group, "theta")==0)		return 5;
if (strcmp(group, "alpha")==0)		return 10;
if (strcmp(group, "lowbeta")==0)	return 14;
if (strcmp(group, "midbeta")==0)	return 17;
if (strcmp(group, "highbeta")==0)	return 20;
if (strcmp(group, "gamma")==0)		return 40;
else return 10;
}

int meskalin::getint(char *string)
{
int ret = 0;
ret = atoi(string);
return ret;
}

void meskalin::startio(void)
{

#ifdef __FreeBSD__
	if(i386_set_ioperm(base, 1, 1))
#else
	if(ioperm(base, 1, 1))
#endif

	{
	printf("ioperm() failed\n");
	exit(0);
	}

}

void meskalin::outio(int value)
{
#ifdef __FreeBSD__
	outb(base, value);
#else
	outb(value, base);
#endif
}

void meskalin::normal(int frequency)
{
int sleepy;
startio();
sleepy = (1000/frequency * 500);

printf("meskalin parport outputting started\n");
printf("pattern: normal\n");
printf("frequency: %i hertz\n", frequency);
printf("usleep() delay: %i microseconds\n", sleepy*2);

	while(1)
	{
		outio(255);
		usleep(sleepy);
		outio(0);
		usleep(sleepy);
	}
}



void meskalin::flipflop(int frequency)
{
int sleepy;
startio();
sleepy = (1000/frequency * 500);

printf("meskalin parport outputting started\n");
printf("pattern: flipflop\n");
printf("frequency: %i hertz\n", frequency);
printf("usleep() delay: %i microseconds\n", sleepy*2);

	while(1)
	{
		outio(170);
		usleep(sleepy);
		outio(85);
		usleep(sleepy);
	}
}

void meskalin::chasing(int frequency, char *type)
{
int sleepy;
startio();

printf("strlen: %i\n", strlen(type));

	if(strcmp(type, "clockwise")==0) // clockwise mode
	{
		sleepy = (1000/frequency * 250);
		printf("pattern: chasing [clockwise]\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*4);
		while(1)
		{
			outio(40);
			usleep(sleepy);
			outio(17);
			usleep(sleepy);
			outio(130);
			usleep(sleepy);
			outio(68);
			usleep(sleepy);
		}
	}
	
	if(strcmp(type, "anticlockwise")==0) // anticlockwise mode
	{
		sleepy = (1000/frequency * 250);
		printf("pattern: chasing [anticlockwise]\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*4);
		while(1)
		{
			outio(40);
			usleep(sleepy);
			outio(68);
			usleep(sleepy);
			outio(130);
			usleep(sleepy);
			outio(17);
			usleep(sleepy);
		}
	}

	if(strcmp(type, "wacky_reverse")==0) // wacky_reverse mode
	{
		sleepy = (1000/frequency * 250);
		printf("pattern: chasing [wacky_reverse]\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*4);
		while(1)
		{
			outio(34);
			usleep(sleepy);
			outio(17);
			usleep(sleepy);
			outio(136);
			usleep(sleepy);
			outio(68);
			usleep(sleepy);
		}
	}

	else
	{ // wacky mode
		sleepy = (1000/frequency * 250);
		printf("pattern: chasing [wacky]\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*4);
		while(1)
		{
			outio(34);
			usleep(sleepy);
			outio(68);
			usleep(sleepy);
			outio(136);
			usleep(sleepy);
			outio(17);
			usleep(sleepy);
		}
	}
}

void meskalin::windowlicker(int frequency, char *option)
{
int sleepy;
printf("meskalin parport outputting started\n");
startio();
	if(strcmp(option, "reverse")==0) // windowlicker reverse mode
	{
		sleepy = (1000/frequency * 500);
		printf("pattern: windowlicker [reverse]\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*2);
		while(1)
		{
		// 2.3.7.8	:5.6.1.4
		// 2.4.64.128	:16.32.1.8
		// 198		:57
			outio(198);
			usleep(sleepy);
			outio(57);
			usleep(sleepy);
		}
	}
	if(strcmp(option, "inwards")==0) // windowlicker inwards mode
	{
		sleepy = (1000/frequency * 500);
		printf("pattern: windowlicker [inwards]\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*2);
		while(1)
		{
		// 6.7.2.3	:5.8.1.4
		// 32.64.2.4	:16.128.1.8
		// 102		:153
			outio(102);
			usleep(sleepy);
			outio(153);
			usleep(sleepy);
		}
	}
	if(strcmp(option, "outwards")==0) // windowlicker outwards mode
	{
		sleepy = (1000/frequency * 500);
		printf("pattern: windowlicker [outwards]\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*2);
		while(1)
		{
		// 5.6.1.2	:8.7.3.4
		// 16.32.1.2.	:128.64.4.8
		// 51		:204
			outio(51);
			usleep(sleepy);
			outio(204);
			usleep(sleepy);
		}
	}
	else // windowlicker mode
	{
		sleepy = (1000/frequency * 500);
		printf("pattern: windowlicker\n");
		printf("frequency: %i hertz\n", frequency);
		printf("usleep() delay: %i microseconds\n", sleepy*2);
		while(1)
		{
		// 4.3.6.7	:1.2.5.8
		// 8.4.32.64	:1.2.16.128
		// 108		:147
			outio(108);
			usleep(sleepy);
			outio(147);
			usleep(sleepy);
		}
	}
}

void meskalin::reset(void)
{
startio();
outio(0);
printf("parport output resetted\n");
exit(0);
}

void meskalin::address(int address)
{
printf("meskalin parport outputting started\n");
printf("sending \'1\' to parport adress: %i\n", address);
startio();
outio(address);
printf("done...\n");
exit(0);
}

void meskalin::led(int led)
{
int address;

	if(led==1)		address = 1;
	if(led==2)		address = 2;
	if(led==3)		address = 4;
	if(led==4)		address = 8;
	if(led==5)		address = 16;
	if(led==6)		address = 32;
	if(led==7)		address = 64;
	if(led==8)		address = 128;
	if(led>8||led<1)	address = 255;

printf("meskalin parport outputting started\n");
printf("sending \'1\' to led %i\n", led);
printf("sending \'1\' to parport adress: %i\n", address);
startio();
outio(address);
printf("done...\n");
exit(0);
}

void meskalin::freqvar(char *type, char *pattern)
{
printf("freqvar: %s:%s\n", type, pattern);
exit(0);


}

