/*
 *  $Id$
 *
 *  socket.c - Opens a raw IP socket and sets the IP_HDRINCL socket option
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */

#include "../include/libnet.h"

int
open_raw_sock()
{
    int fd, one = 1;

    if ((fd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
    {
        perror("open_raw_socket: SOCK_RAW allocation error");
        return (-1);
    }
    if (setsockopt(fd, IPPROTO_IP, IP_HDRINCL, &one, sizeof(one)) < 0)
    {
        perror("open_raw_socket: Cannot set IP_HDRINCL socket option");
        return (-1);
    }
    return (fd);
}


/* EOF */
