/*
 *  $Id$
 *
 *  test.c - Test code for libnet.
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */

#include <unistd.h>
#include "include/libnet.h"

#define VALID_TESTIP    "192.168.2.100"

int main(int argc, char **argv)
{
    int fd;
    u_long in;

    /*
     *  hostname -> network byte order
     */
    if ((in = name_resolve(VALID_TESTIP)) == -1)
    {
        fprintf(stderr, "hostname -> network byte order failed\n");
    }
    else 
    {
        fprintf(stderr, "hostname -> network byte order succeeded\n");
    }
    /*
     *  network byte order -> hostname
     */
    if (!strcmp(host_lookup(in), VALID_TESTIP))
    {
        fprintf(stderr, "network byte order -> hostname succeeded\n");
    }
    else
    {
        fprintf(stderr, "network byte order -> hostname failed\n");
    }

    /*
     *  Raw socket test
     */
    if ((fd = open_raw_sock()) == -1)
    {
        fprintf(stderr, "raw socket failed\n");
    }
    else
    {
        fprintf(stderr, "raw socket succeeded\n");
        if (close(fd) == -1)
        {
            perror("close");
            exit(1);
        }
    }
    return (0);
}

/* EOF */
