#!WHICH_PERL
# deceptive defense - wear down the attackers and all their port scanners and so forth
# Copyright (c), 1998, Fred Cohen - All Right Reserved

# NOTICE: By taking this copy, you agree that all updates and midifications
# will be reported back to us, that you will only use it to defend systems and
# not to figure out how to attack them, that we retain all right to the
# software provided to you and any revisions, enhancements, or derivitive
# works that may result from it, that you will retain all copyright notices on
# all copies you distribute elsewhere, and that anyone you give it to will
# also agree to these terms.

$prompt="This system is running deception toolkit - you are being watched and logged:";
							# default initial (and ongoing) prompt
$timeout=TIME_OUT;					# seconds to say something else or I go away
$maxloops=MAX_LOOP;					# maximum number of input lines before we exit anyway
$state="0";						# Initial state is always "0"
$debug=0;						# no debugging messages please
$PERLLIB="WHICH_PERL_LIB";

$progname="listen.pl";

sub byebye {if ($debug == 1) {print "ByeBye exit $con, $$, $port, $OurPort\n";}
	if ($debug == 1){print "Turning off alarm and catcher $con $port\n";}
	alarm(0);catcher('');				# stop sending signals and stop catching them
	if ($debug == 1){print "Logging $_[0] for $con $port\n";}
	$IN=$_[0];LOGON();				# log the results
	if ($debug == 1){print "$con closing $port\n";}
	close(NS);close(S);				# close everything I may have left open
	kill 'USR1', $listenPID;			# tell my parent to reap for me
	exit(0); print "Can't Exit!!!\n";}		# and die

# timeout or other signal logged as timeout, show coredump, close, exit
sub childhandler {$ipadd='0.0.0.0';$tmp="ChildSignal $_[0]";	# log the signal
		catcher('');				# stop catching signals
		print NS "core dumped";if ($debug == 1) {print "Childexit\n";}
		byebye($tmp);exit(0);}			# say bye and exit if it returns

sub parenthandler {$ipadd='0.0.0.0';$IN="ParentSignal $_[0]";
		deathcatch('');catcher('');		# stop catching signals
		$ocon=$con;$con=0;LOG();$con=$ocon;	# log the signal
		if ($debug == 1) {print "Parent exit\n";}
		close(NS);close(S);			# close everything out
		exit(0);}				# close out

sub parentreaper {$tmp=wait;				# wait for the dead child
		if ($debug == 1){print "Death of $tmp\n";};
		return;}				# end it's zombie existence

sub catcher {for $sig ('ALRM', 'HUP', 'PIPE') {$SIG{$sig}=$_[0];}} # catch timeouts, hangups, endless pipe
sub deathcatch {for $sig ('USR1') {$SIG{$sig}=$_[0];}}	# catch terminations
deathcatch('parentreaper');				# set up to handle self-terminated children

($port) = @ARGV;$port = 365 unless $port;		# port provided by user or defaults to deception port
$OurPort=$port;						# the port we are listening on
# $AF_INET=2;$SOCK_STREAM=1;				# IP / stream - not datagram
require "WORKING_DIR/socket.ph";			# the constants associated with sockets and protocols
$sockaddr='S n a4 x8';					# how we unpack packet headers for now
$partialaddr='S n a4';					# how we unpack unterminated packets for now
($name, $aliases, $proto) = getprotobyname('tcp');	# TCP protocol
if ($port!~ /^\d+$/) {($name, $aliases, $port) = getservbyport($port, 'tcp');}	# by service name?
if ($debug == 1) {print "Port = $port\n";}

# initialize values for prompt, etc. if there is a file to read from

# while true do the rest of this loop in a fork and place timeouts on calls that could wait forever?
catcher('parenthandler');				# setup parent process signal handler
socket(S, $AF_INET, $SOCK_STREAM, $proto) || die "socket: $!";	# plug into the socket or die trying
$this=pack($sockaddr, $AF_INET, $port, "\0\0\0\0");	# setup for bind
bind(S,$this) || die "bind: $!";			# bind to the socket or die trying
listen(S,5) || die "connect: $!";			# listen for connects or die trying
select(S); $|=1; select(stdout);			# every byte as it comes in
$listenPID=$$;$realtime=0;				# parent ID of the listener - no realtime yet
chdir "WORKING_DIR" || die "configuration error - please contact the site administrator\n";
require 'logging.pl';					# logging setup and routines
require 'respond.pl';
require 'orders.pl';
# go to the right directory for this stuf
if (!-e "$port.response") {die "configuration file error - please contact the site administrator\n";}
# if no file, a generic error message
open(File,"<WORKING_DIR/$port.response");@tmp=<File>;close(File);
@XREF=grep('!^#',@tmp);@ORDERS=grep(/^!/,@XREF);DoOrders();	# get Xref and Orders
if ($debug == 1) {foreach $i (@XREF) {print "$i\n";}}
for ($con=1;;$con++)						# count the connection numbers (just for fun)
	{if ($con > 64000) {$con=1;}				# wouldn't want to run out - we recycle
	if ($debug == 1) {printf ("Listening for connection %d...\n",$con);}
	while (!($addr = accept(NS,S)))				# wait to accept a valid request
		{select(NS); $|=1;select(stdout);$|=1;		# every byte as it comes in
		($af, $badport, $inetaddr) = unpack($partialaddr, $addr);	# unpack the packet
		@inetaddr = unpack('C4', $inetaddr);		# split out the IP address of the caller
		$ipadd="@inetaddr[0].@inetaddr[1].@inetaddr[2].@inetaddr[3]";	# printable IP
		if ($ipadd eq "...") {$ipadd = "0.0.0.0";}	# Oops - no address available
		$IN="PortScan";					# looks like a half-open, or fin ... port scan
		$ocon=$con;$con=0;LOGON();$con=$ocon;close(NS);}# Log the partial open attempt
	if (($child = fork()) == 0)				# split in two - the child takes the IO
		{sleep(2);					# give the parent a chance to prepare
								# prevents a race with the parent process
		open(File,"<WORKING_DIR/$port.response");@tmp=<File>;close(File); # refetch the response file
		@XREF=grep('!^#',@tmp);@ORDERS=grep('\!',@XREF);DoOrders();	# get Xref and Orders
		setpriority(0, 0, getpriority(0, 0) +1);	# make me one nicer than my parent
		select(NS); $|=1;select(stdout);$|=1;		# every byte as it comes in
		catcher('childhandler');alarm($timeout);	# handle timeout signals and timeout on input
		$continue="1";$realtime=0;			# we have not shut the session down (yet) - time starts
		($af, $port, $inetaddr, $junk) = unpack($sockaddr, $addr);	# unpack the packet
		if ($debug == 1) {print "accept ok\n";}
		@inetaddr = unpack('C4', $inetaddr);		# split out the IP address of the caller
		if ($debug == 1) {print "$con : $af @inetaddr[0].@inetaddr[1].@inetaddr[2].@inetaddr[3] $port \n";}
		$ipadd="@inetaddr[0].@inetaddr[1].@inetaddr[2].@inetaddr[3]";	# printable IP
		$IN="Init";LOGON();$loopcount=0;		# Log the startup and count the loops
		$what="START";$IN="START";RESPOND(NS);		# respond to the initial entry
		while ($continue ne "0")			# while we are willing
			{if (!($IN=<NS>)) {byebye("NoInput");}	# unless the socket is done
			alarm($timeout);$loopcount=$loopcount+1; # input means we keep going
			if ($loopcount > $maxloops)		# Exceeded loop count?
				{print NS "core dumped";byebye("MaxLoop");}
			if ($debug == 1) {print "$con: $IN";}
			($what, $garbage)=split(" ",$IN,2);	# command and content?
			LOGON();				# log each entry
			$what=~y/A-Za-z0-9//cd;			# safe grep capability
			$what=~tr/A-Z/a-z/;			# case independent
			if ($what eq "") {$what="NIL";}		# except for special cases like NIL/ERROR
			RESPOND(NS);}				# interpret the input
		if ($debug == 1) {print "Termination of $con\n";}
		byebye("WeClose");}				# if we are closing, say so
	else {if ($debug == 1) {print "child $child born\n";}	# we are the parent
		if ($debug == 1){print "Parent close $port\n";}
		close(NS);}					# close parent DUP of socket
	}							# loop to await the next request
exit(0);			# just to be thorough - even though this can never happen
