#!WHICH_PERL
# deceptive defense - wear down the attackers and watch them as they do it
# Copyright (c), 1998, Fred Cohen - All Right Reserved

# NOTICE: By taking this copy, you agree that all updates and midifications
# will be reported back to us, that you will only use it to defend systems and
# not to figure out how to attack them, that we retain all right to the
# software provided to you and any revisions, enhancements, or derivitive
# works that may result from it, that you will retain all copyright notices on
# all copies you distribute elsewhere, and that anyone you give it to will
# also agree to these terms.

# formats for response files:
#	# anything is ignored as a comment
#	STATE	!	NEXTSTATE CONTINUE CRLF STIMULUS RESPONSE	Match STIMULUS -> response
#	STATE	!O	NEXTSTATE CONTINUE CRLF RESPONSE		Match One Time Password -> response
#	STATE	!A	NEXTSTATE CONTINUE CRLF RESPONSE		Match Algorithmic Authentication -> response
#	STATE	!T	NEXTSTATE CONTINUE CRLF RESPONSE		Match Time-based Authentication -> response
#	STATE	M!patternmatch!	NEXTSTATE CONTINUE CRLF RESPONSE	Match patternmatch -> response
#	STATE	/patternmatch/	NEXTSTATE CONTINUE CRLF RESPONSE	Match patternmatch -> response
#	STATE	word	NEXTSTATE CONTINUE CRLF RESPONSE		Match first word -> response

# response codes for CRLF:
#	InX = set the Infocon level to n and crlf is otherwise treated as if it were X
#	1 = add a CRLF to the end
#	cat = cat the file - No CRLF at the end
#	-echo = echo response and turn off echo
#	+echo = echo <CRLF>response and turn on echo
#	@ = start new response profile from next field
#	exec = exec a process (login for example)
#	infocon = List the Infocon states and times
#	ipcon = List the IP address sizes and times
#	special = special coding for altered states
#		for example, special in.telnetd	allow	allows telnet from the current IP
#		for example, special in.telnetd	deny	denies telnet from the current IP
#		for example, special all	deny	denies all from the current IP
#	by-default = echo the response to the user - no CRLF

require 'infocon.pl';

sub Rprint {local $line=$_[0];
		if ($debug == 1) {print "RPrinting $line\n";}
		if ($progname eq "UDPlisten.pl")
			{# socket(RS, $AF_INET, $SOCK_DGRAM, $proto) || die "socket: $!";	# plug into the socket or die trying
			send(S, "$line", 0, $theiraddr);		# send on the socket and we're done?!?
			}
		else	{if (0 == print $F $line) {byebye("PortScanClosed");}
			if ($debug == 1) {print "Rprint worked\n";}}
		return;}
	# if print fails - closed filehandle or socket - from a finscan no doubt

# the response generated from the nn.response file
sub RESPOND {$F=$_[0];
	if ($debug == 1) {print "Responding to $con in S$state\n";}
	if ($slowly != 0) {sleep($slowly);}	# slow host down is requested
	while ((index($IN,"\r",$[) >= $[) || (index($IN,"\n",$[) >= $[)) {chop($IN);}	# kill trailing input characters
	$content=0;@set=grep(/^$state	!	/,@XREF);
	foreach $i (@set)
		{($state, $bang, $nextstate, $continue, $crlf, $stimulus, $response)=split(" ",$i,7);
		$_=$IN;if (?$stimulus?) {$content=1;last;}}
	if ($content == 0)		# let's try for OTP
		{@set=grep(/^$state	!O	/,@XREF);
		foreach $i (@set)
			{($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$i,6);
			if (OTP($stimulus) == 1) {$content=1;last;}}}
	if ($content == 0)		# not an OTP line, let's try for Time Based
		{@set=grep(/^$state	!T	/,@XREF);
		foreach $i (@set)
			{($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$i,6);
			if (TBP($stimulus) == 1) {$content=1;last;}}}
	if ($content == 0)		# not a Time Based line, let's try for Algorithmic
		{@set=grep(/^$state	!A	/,@XREF);
		foreach $i (@set)
			{($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$i,6);
			if (ALG($stimulus)) {$content=1;last;}}}
# match patterns - m!.....! OR /...../
	if ($content == 0)		# not an Algorithmic line, let's try for a pattern space
		{@set=grep(/^$state	M/,@XREF);
		foreach $i (@set)
			{($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$i,6);
			($m, $n)=split(//, $stimulus, 2);$m="m$n";
			# if ($debug == 1) {Rprint("m$n matched against $IN\n");}
			$_=$IN;if (eval($m)) {$content=1;last;}}}
	if ($content == 0)		# not an m line, let's try for /
		{@set=grep(/^$state	\//,@XREF);
		foreach $i (@set)
			{($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$i,6);
			$_=$IN;if (eval($stimulus)) {$content=1;last;}}}
# match first word
	if ($content == 0)		# no pattern matches, try straight text matches for first word
		{@pair=grep(/^$state	$what/,@XREF);$pair=@pair[0];
		if ($pair eq "") {@pair=grep(/^$state	ERROR/,@XREF);$pair=@pair[0];}
		($state, $stimulus, $nextstate, $continue, $crlf, $response)=split(" ",$pair,6);}
	chop($response);
	if ($debug == 1) {print "Response should be $response - crlf = $crlf\n";}
	if (substr($crlf,$[,1) eq "I")		# Set the infocon level and use the rest of CRLF
		{$i=substr($crlf,$[+1,1);setinfocon($i); $crlf=substr($crlf,$[+2);}
	if ($crlf eq "1") {Rprint ("$response\n\r");}
	elsif ($crlf eq "cat")
		{if ($debug == 1) {print "Getting file $response\n";}
		open(File,"<$response");@CONTENT=<File>;close(File);$len=@CONTENT;
		if ($debug == 1) {print "Printing file $response\n";}
		$tmp="";foreach $i (@CONTENT){chop($i);$len=$len-1;
			if ($len == 0) {$tmp="$tmp" . "$i";} else {$tmp="$tmp" . "$i\r\n";}}
		Rprint($tmp);}
	elsif ($crlf eq "-echo") {system("stty -echo");Rprint ("$response");}
	elsif ($crlf eq "+echo") {system("stty echo");Rprint ("\r\n$response");}
	elsif ($crlf eq "exec") {exec($response);}
	elsif ($crlf eq "special")
		{($wrapperservice, $wrapperfunction) = split(" ", $response,2);
		$wrapperline="$wrapperservice:	$ipadd:	$wrapperfunction\n\# $wrapperservice:  $ipadd: $wrapperfunction DTK SPECIAL\n";
		Rprint("Ouch!!!\n");
		open(File,">newwrappers");print File "$wrapperline";close(File);
		system("/bin/cat /etc/hosts.allow >> newwrappers;cp /etc/hosts.allow /etc/hosts.allow.old;cp newwrappers /etc/hosts.allow");
		}
	elsif ($crlf eq "infocon")		# provide times for each infocon level
		{$tmp="";foreach $i (0, 1, 2, 3, 4, 5, 6, 7, 8, 9)
			{($dev, $ino, $mode, $nlink, $uid,$gid, $rdev, $size,
			$atime, $mtime,	$ctime, $blksize, $blocks) = stat("WORKING_DIR/InfoCon.$i");
			$tmp="$tmp" . "$i=$mtime\n";}
		Rprint($tmp);}
	elsif ($crlf eq "ipcon")		# provide times and sizes for each IP log file
		{opendir(IPDIR, "WORKING_DIR/IP");@IPs=grep(!/^\.\.?$/,readdir(IPDIR));closedir(IPDIR);
		$tmp="";foreach $i (@IPs)
			{($dev, $ino, $mode, $nlink, $uid,$gid, $rdev, $size,
			$atime, $mtime,	$ctime, $blksize, $blocks) = stat("WORKING_DIR/IP/$i");
			$tmp="$tmp" . "$i $mtime $size\n";}
			Rprint("$tmp\n");
		}
	elsif ($crlf eq "@")			# @ means run from new response file
		{open(File,"<WORKING_DIR/$response");@tmp=<File>;close(File);
		@XREF=grep('!^#',@tmp);@ORDERS=grep(/^!/,@XREF);DoOrders();	# get Xref and Orders
		if ($state eq UDP) {$nextstate="UDP";} else {$nextstate=0;}}
	else    {Rprint("$response");}	# otherwise print the response as is
	$state=$nextstate;
	if ($debug == 1) {print "Nextstate = $nextstate\n";}
	@set=grep(/^$state	NOTICE/,@XREF);
	foreach $i (@set)			# notification on next state entry
		{($state, $notify, $program, $parameters)=split(" ",$i,4);
		system("$program $port $state $parameters");
		$IN="$notify $program $port $state $parameters";LOGON();}
	reconfigure($port, $state);		# redonfigure based on the port and state
	}

sub OTP {$input=$_[0];			# get the input, compare to all OTP entries
	open(File,"<WORKING_DIR/OTP");@tmp=<File>;close(File);$otpok=0;
	foreach $tmp (@tmp) {chop($tmp);if ($tmp eq $IN) {$otpok=1;}
				else {push(@tmp2,$tmp);}}
				# unmatched means leave it for the OTP file
	if ($otpok == 1) {open(File,">WORKING_DIR/OTP");	# if a match, rewrite OTP and succeed
			foreach $tmp (@tmp2) {print File "$tmp\n"}
			close(File);return 1;}
	else {return 0;}					# otherwise fail miserably
	}

sub ALG {return 0;}
# no Algorithmic Authentication for now

require "oneway.pl";

return(TRUE);
