#!/usr/bin/perl
$HOSTNAME="1.2.3.4";
$PORTNO=1111;
$MSG="cat /etc/passwd";

$ARGC=$#ARGV+1;

$x=0;
while($x < $ARGC)
	{$y=$ARGV[$x];
	if ($y eq "-?") {print "udptest.pl [-? | -h host | -p port | -m message]+\n";}
	elsif ($y eq "-h") {$x++;$HOSTNAME=$ARGV[$x];}
	elsif ($y eq "-p") {$x++;$PORTNO=$ARGV[$x];}
	elsif ($y eq "-m") {$x++;$MSG=$ARGV[$x];}
	else {print "Illegal argument $y\n";}
	$x++;
	}

$MAXLEN=65535;

print "UDPtest $HOSTNAME:$PORTNO <= $MSG => ";
use Socket; 
if (socket(SockHandle, PF_INET, SOCK_DGRAM, getprotobyname("udp")) == 0) {print "socket: $!\n";exit;}
$ipaddr   = inet_aton($HOSTNAME);
$portaddr = sockaddr_in($PORTNO, $ipaddr); 
if (send(SockHandle, $MSG, 0, $portaddr) != length($MSG)) {print "cannot send to $HOSTNAME($PORTNO): $!\n";exit;}
$portaddr = recv(SockHandle, $MSG, $MAXLEN, 0);
if (!defined($portaddr)) {print "recv: $!\n";exit;}
# $portaddr = recv(SockHandle, $MSG, $MAXLEN, 0)
($portno, $ipaddr) = sockaddr_in($portaddr); 
$host = gethostbyaddr($ipaddr, AF_INET); 
print "$host($portno) said $MSG\n"; 
