(*
** PURPOSE: Illustrates the dangers of turning off strict checking
** COMPILE: ipw -s- notstric
** RUN:     ivm notstric
** NOTE:    The value of 'i' is changed by the assignment to 's'.
**          Because an assignment to 's' is actually an assignment
**          to 'x' but the 'Hello world!' is too long to fit in 'x'
**          so it overflows into 'i'.
**          (see the discussion on the strict checking in "user.txt"
**          for more information). 
*)
program NotStrict(output);
var
   x : string[7];
   i : integer;

   procedure f(var s : string);
   begin
      writeln('Before assignment i =', i);
      s := 'Hello world!'; (* assignment to global 'x' through 's' *)
      writeln('After assignment i =', i)
   end;

begin
   i := 0;
   f(x)
end.
