#!/usr/bin/env perl

## --> GNU/Linux AX.25 Setup Program For Green Bay, Wisconsin
## --> By Green Bay Professional Packet Radio, www.qsl.net/n9zia
# 
# Certain parts may be Red Hat specific. Tested with a 1200 bps KPC-3
# with a system using the normal AX.25 tools
# 
# This script uses no modules, and can be run with just the perl binary
#
# AX.25 tools are located at ftp://ftp.hes.iki.fi/pub/ham/linux/ax25/
#

## User setup

$ax25root = "/usr/local/etc/ax25";    # AX.25 root directory
$des = "1200 GB LAN";                 # description for the axports file
$gw = "44.92.20.5";                   # default gateway IP address
$name = "ax0";                        # TNC port name
$txdelay = 100;                       # transmit delay, ten millisecond
                                      # intervals, 100
$persist = 128;                       # persist value, 0-255  
                                      # (256 / number of channel users)
$slot = 20;                           # slottime, ten millisecond intervals, 20

## Misc setup

$ax25init = "/etc/rc.d/init.d/ax25";   # start/stop file
$ax25rcd = "/etc/rc.d/rc.ax25";        # /etc/rc.d/rc.ax25
$hosts = "/etc/hosts";                 # /etc/hosts
$ver = "4.0";                          # version

## TCP/IP/routing parameters

$data = 216;                        # data bytes
$paclen = $data + 40;               # maximum packet length, 256
$mtu = $data + 40;                  # maximum transfer unit, 256
$mss = $data;                       # TCP maximum segment size 
                                    # multiple of MTU data bytes, 216
$window = $data * 2;                # TCP window size, 2 packets, 432
$irtt = 10000;                      # initial round trip time (irtt) for TCP 
                                    # connections, milliseconds, 10 seconds
$netmask = "255.255.255.0";         # default netmask 

## Start subroutines and script variables

$bld = "\033[37m\033[1m";
$cyn = "\033[36m\033[1m";
$red = "\033[31m\033[1m";
$clr = "\033[0m";

sub b_to_d {
my $n = shift;
my @n = split //,$n;
my $mult = 1;
my $dec = 0;
for (1..length $n) {
        $dec += $mult * (pop @n);
	$mult *= 2;
 }
return $dec;
}

sub d_to_b {
my $n = shift;
if ($n == "0") {
        $bin = "00000000";
        return $bin;
}
my $mod = 0;
my @bin = ();
while ($n > 0) {
       $mod = $n % 2;
       unshift @bin, $mod;
       $n = int ($n / 2);
 }
$bin = join '', @bin;
$bin = &pad($bin,8);
return $bin;
}

sub bin_out {
my $bin = shift;
my @bin = split //,$bin;
my $ctr = 1;
for (@bin) {
        print;
        if ($ctr++ == 8) {
        	print " ";
	        $ctr = 1;
	 }
 }
}

sub pad {
my $n = shift;
my $pad = shift;
my $l = length $n;
my $mod = $l % $pad;
unless ($mod == 0) {
        my $extra_zeros = $pad - $mod;
        for (0..$extra_zeros-1) {
        	$n = '0'.$n;
	}
 }
return $n;
}

sub An_Array {
my @n = split //, $n;
undef $array;
splice(@array, 0);
my $c = 1;
for (@n) {
	push(@array,$_);
        if ($c++ == 8) {
        	push(@array," ");
        $c = 1;
 	}		
}
foreach (@array) {
	$array .= $_;
 }
}

## Start calculations

print "\33[H\33[J".
      "\n\t$bld GNU/Linux AX.25 Setup Program for Green Bay, Wisconsin, ".
      "v$ver$clr\n\n";

while (!$call) {
	print "Enter your$cyn callsign$clr : ";
	chomp($call = <STDIN>);
	$call =~ tr/a-zA-Z0-9//csd;
	$call =~ tr/a-z/A-Z/;
}

print "\n";

while (!$speed) {
	print "Enter your$cyn TNC's speed $clr(bps) : ";
	chomp($speed = <STDIN>);
	$speed =~ tr/0-9//csd;
}

if ($speed == 1200) {
	print "\n1200 bps?!? Hahahahahahhehehahhooowhwowwh. cough.\n";
}

print "\n";

while (!$tty) {
	print "\n1.  /dev/ttyS0 (COM1)\n".
	      "2.  /dev/ttyS1 (COM2)\n".
	      "3.  /dev/ttyS2 (COM3)\n".
	      "4.  /dev/ttyS3 (COM4)\n".
	      "5.  Enter your own device\n\n".
	      "Choose which$cyn serial port$clr your TNC is on : ";
	chomp($tty = <STDIN>);
	$tty =~ tr/0-9//csd;

	if ($tty == 1) {
		$tty = "/dev/ttyS0";
	}
	elsif ($tty == 2) {
		$tty = "/dev/ttyS1";
	}
	elsif ($tty == 3) {
		$tty = "/dev/ttyS2";
	}
	elsif ($tty == 4) {
		$tty = "/dev/ttyS3";
	}
	elsif ($tty == 5) {
		print "\nEnter your own device name : ";
		chomp($tty = <STDIN>);
	}
	else {
		undef $tty;
	}
}

print "\n   Callsign : $bld$call$clr\n".
      "  TNC speed : $bld$speed$clr bps\n".
      "Device port : $bld$tty$clr\n\n";

while (!$_) {
	print "Does all this look correct so far?  [y|n] : ";
	chomp($_ = <STDIN>);
	tr/ynYN//csd;
}

if (/y/i) {
       undef $_;
       print "\nContinuing...\n\n";
}
else {
	print "\n$red Start over. $clr\n\n";
	exit;
}

while (!$ip) {
        print "Enter your assigned$cyn AMPR IP$clr address : ";
	chomp($ip = <STDIN>);
	$ip =~ tr/0-9.//csd;
}

($ip1, $ip2, $ip3, $ip4) = split /\./, $ip;

if ($ip1 > 255 || $ip2 > 255 || $ip3 > 255 || $ip4 > 255) {
	print "\n$red Out of range IP address. $clr\n\n";
	exit;
}

print "\n";

while (!$mask) {
        print "Enter your assigned$cyn netmask$clr address ($netmask) : ";
	chomp($mask = <STDIN>);
	$mask =~ tr/0-9.//csd;
}

($mask1, $mask2, $mask3, $mask4) = split /\./, $mask;

if ($mask1 > 255 || $mask2 > 255 || $mask3 > 255 || $mask4 > 255) {
	print "\n$red Out of range netmask address. $clr\n\n";
	exit;
}

print "\n";

$ip1bin = &d_to_b($ip1);
$ip2bin = &d_to_b($ip2);
$ip3bin = &d_to_b($ip3);
$ip4bin = &d_to_b($ip4);

$mask1bin = &d_to_b($mask1);
$mask2bin = &d_to_b($mask2);
$mask3bin = &d_to_b($mask3);
$mask4bin = &d_to_b($mask4);

$wrk1bin = $ip1bin & $mask1bin;
$wrk2bin = $ip2bin & $mask2bin;
$wrk3bin = $ip3bin & $mask3bin;
$wrk4bin = $ip4bin & $mask4bin;

$wrk1 = &b_to_d($wrk1bin);
$wrk2 = &b_to_d($wrk2bin);
$wrk3 = &b_to_d($wrk3bin);
$wrk4 = &b_to_d($wrk4bin);

$network = $wrk1bin.$wrk2bin.$wrk3bin.$wrk4bin;

$z = ($mask1bin.$mask2bin.$mask3bin.$mask4bin) =~ tr/0/0/;

$broadcast = $network | ((0 x (32 - $z)) . (1 x $z));

$work = $wrk1.".".$wrk2.".".$wrk3.".".$wrk4;

print "\nAddresses that will be used:\n\n".
      "       IP : $ip1bin $ip2bin $ip3bin $ip4bin ($bld$ip$clr)\n".
      "  Netmask : $mask1bin $mask2bin $mask3bin $mask4bin ($bld$mask$clr)\n".
      "  Network : $wrk1bin $wrk2bin $wrk3bin $wrk4bin ($bld$work$clr)\n".
      "Broadcast : ";

&bin_out($broadcast);

&An_Array($n = $broadcast);

($brd1bin, $brd2bin, $brd3bin, $brd4bin) = split ' ', $array;

$broad = &b_to_d($brd1bin).".".&b_to_d($brd2bin).".".&b_to_d($brd3bin).".".&b_to_d($brd4bin);

print "($bld$broad$clr)\n\n";

while (!$_) {
	print "Does all this look correct so far?  [y|n] : ";
        chomp($_ = <STDIN>);
        tr/ynYN//csd;
}

if (/y/i) {
	undef $_;
	print "\nContinuing...\n\n";

}
else {
	print "\n$red Start over. $clr\n\n";
	exit;
}

print "Creating the $ax25root/axports file...\n";

if (-f "$ax25root/axports") {
	rename "$ax25root/axports", "$ax25root/axports.orig";
	print "Backed up $ax25root/axports as $ax25root/axports.orig\n";
}

open F, ">$ax25root/axports" || die "Can't open $ax25root/axports: $!\n";
	print F "# name callsign speed paclen window description\n".
                "$name\t$call\t$speed\t$paclen\t2\t$des\n";
close F;

print "\nCreating the $ax25init file...\n";

if (-f $ax25init) {
	rename "$ax25init", "$ax25init.orig";
	print "Backed up $ax25init as $ax25init.orig\n";
}

open F, ">$ax25init" || "Can't open $ax25init: $!\n";
print F <<EOF;
#!/bin/sh
#
# AX.25 setup

# Source function library.
. /etc/rc.d/init.d/functions

# Get config.
. /etc/sysconfig/network

# Check that networking is up.
if [ \${NETWORKING} = "no" ]
then
	exit 0
fi

# See how we were called.
case "\$1" in
  start)
	action "Starting AX.25 services" /bin/true
	/etc/rc.d/rc.ax25
	touch /var/lock/subsys/ax25

	;;
  stop)
	action "Stopping AX.25 services" killall -TERM kissattach
	rm -f /var/lock/subsys/ax25

	;;
  status)
	if [ -f /var/lock/subsys/ax25 ]; then
		echo "The AX.25 services are running."
	else
		echo "The AX.25 services are not running."
	fi

	;;
  restart|reload)
	# do not do anything; this is unreasonable
	:
	;;
  *)
	echo "Usage: ax25 {start|stop|status|restart}"
	exit 1
esac

exit 0
EOF
close F;

print "\nCreating the $ax25rcd file...\n";

if (-f $ax25rcd) {
	rename "$ax25rcd", "$ax25rcd.orig";
	print "Backed up $ax25rcd as $ax25rcd.orig\n";
}

open F, ">$ax25rcd" || "Can't open $ax25rcd: $!\n";
print F <<EOF;
#!/bin/sh
#
# /etc/rc.d/rc.ax25 file for the AX.25 services, v$ver

PATH=\$PATH:/usr/local/sbin:/usr/local/bin:/sbin

# Configure the device
#
killall -TERM kissattach > /dev/null 2>&1
# kissattach [-6] [-l] [-m mtu] [-v] tty port inetaddr
kissattach -l -m $mtu $tty $name $ip

# Proposed routing table for 1200 bps Green Bay amateur radio LAN
#
# default routes
route add -net $work netmask $mask window $window irtt $irtt mss $mss dev ax0
route add -net 44.0.0.0 netmask 255.0.0.0 window $window irtt $irtt mss $mss gw $gw

# Networked gateways reached via VHF 1200 bps router
#
# N9CFN-4: #446GB 9600 backbone link to Appleton, Manitowoc, etc.
route add 44.92.20.2 window $window irtt $irtt mss $mss gw 44.92.20.5
# KE9PW-5: #GRB4 9600 Green Bay LAN
route add 44.92.20.8 window $window irtt $irtt mss $mss gw 44.92.20.5
# KB9ALN-5: GRBBBS networked AX.25 forwarding BBS
route add 44.92.20.32 window $window irtt $irtt mss $mss gw 44.92.20.5

# Personal internal networks that are reached via other gateways
# **** You should edit these next two sections ****
#
#route add 44.92.20.9 window $window irtt $irtt mss $mss gw 44.92.20.23
#route add 44.92.20.10 window $window irtt $irtt mss $mss gw 44.92.20.23
#route add 44.92.20.37 window $window irtt $irtt mss $mss gw 44.92.20.23
route add 44.92.20.31 window $window irtt $irtt mss $mss gw 44.92.20.11
#route add 44.92.20.38 window $window irtt $irtt mss $mss gw 44.92.20.35
#route add 44.92.20.36 window $window irtt $irtt mss $mss gw 44.92.20.24

# Special routing (bad antennas, poor geographic locations)
#
route add 44.92.20.1 window $window irtt $irtt mss $mss gw 44.92.20.5
route add 44.92.20.23 window $window irtt $irtt mss $mss gw 44.92.20.5
route add 44.92.20.9 window $window irtt $irtt mss $mss gw 44.92.20.5
route add 44.92.20.10 window $window irtt $irtt mss $mss gw 44.92.20.5
route add 44.92.20.24 window $window irtt $irtt mss $mss gw 44.92.20.5
route add 44.92.20.36 window $window irtt $irtt mss $mss gw 44.92.20.5

# ARP table for 1200 bps Green Bay amateur radio LAN
#
# ARP Broadcasts need to respond to AX.25 destination "QST"
arp -H ax25 -s 44.92.255.255 QST-0
# Personal / gateways
arp -H ax25 -s 44.92.20.1 N9CFN
arp -H ax25 -s 44.92.20.2 KE9LZ-5
arp -H ax25 -s 44.92.20.4 KE9LZ
arp -H ax25 -s 44.92.20.5 KE9LZ-5
arp -H ax25 -s 44.92.20.6 KE9PW
arp -H ax25 -s 44.92.20.8 KE9LZ-5
arp -H ax25 -s 44.92.20.9 N9OLY
arp -H ax25 -s 44.92.20.10 N9OLY
arp -H ax25 -s 44.92.20.11 N9PAV
arp -H ax25 -s 44.92.20.20 N9ZDA
arp -H ax25 -s 44.92.20.21 N9PAY
arp -H ax25 -s 44.92.20.22 N9PAW
arp -H ax25 -s 44.92.20.23 N9OLY
arp -H ax25 -s 44.92.20.24 N9NCQ
arp -H ax25 -s 44.92.20.30 N9NCI
arp -H ax25 -s 44.92.20.32 KE9LZ-5
arp -H ax25 -s 44.92.20.35 KB9MWR
arp -H ax25 -s 44.92.20.36 N9NCQ
arp -H ax25 -s 44.92.20.37 N9OLY
arp -H ax25 -s 44.92.20.38 KB9MWR
arp -H ax25 -s 44.92.20.39 N9ZDA
arp -H ax25 -s 44.92.20.43 N9DKH

# Miscellaneous
#
listen -a -c -t > /dev/tty11 &

# Set TNC parameters
#
# kissparms -p <port> [-f y|n] [-h hw] [-l txtail] [-r pers]
# [-s slot] [-t txd] [-e feclevel] [-v] [-x]
kissparms -p $name -r $persist -s $slot -t $txdelay

EOF
close F;

open F, $ax25rcd || die "Can't open $ax25rcd: $!\n";
	@F = <F>;
close F;

open F, ">$ax25rcd.bak" || die "Can't open $ax25rcd.bak: $!\n";
	foreach (@F) {
		if (/^arp/) {
			if (/$ip/) {
				$_ =~ s/arp/#arp/;;
		 	}
		}
	print F;
}
close F;

while (!$_) {
	print "\n\nDo you want to update your $hosts file?  [y|n] : ";
	chomp($_ = <STDIN>);
	tr/ynYN//csd;
}

if (/y/i) {

	print "\nAppending to the $hosts file...\n";

	if (-f $hosts) {
	        `/bin/cp -f $hosts $hosts.orig`;
		 print "Backed up $hosts as $hosts.orig\n";
	}

	open F, ">>$hosts" || die "Can't open $hosts: $!\n";
	print F "# North Eastern Wisconsin AMPR hosts file\n".
	        "# Green Bay Subnet 44.92.20.x\n".
	        "#\n".
	        "44.92.20.1 n9cfn.ampr.org n9cfn\n".
	        "44.92.20.2 n9cfn-4.ampr.org n9cfn-4\n".
	        "44.92.20.3 n9cfn-5.ampr.org n9cfn-5\n".
	        "44.92.20.4 ke9lz.ampr.org ke9lz\n".
	        "44.92.20.5 ke9lz-5.ampr.org ke9lz-5\n".
	        "44.92.20.6 ke9pw.ampr.org ke9pw\n".
	        "44.92.20.7 ke9pw-1.ampr.org ke9pw-1\n".
	        "44.92.20.8 ke9pw-5.ampr.org ke9pw-5\n".
	        "44.92.20.9 kb9aln.ampr.org kb9aln\n".
	        "44.92.20.10 kb9aln-1.ampr.org kb9aln-1\n".
	        "44.92.20.11 n9pav.ampr.org n9pav\n".
	        "44.92.20.12 n9svk.ampr.org n9svk\n".
	        "44.92.20.20 n9zda.ampr.org n9zda\n".
	        "44.92.20.21 n9pay.ampr.org n9pay\n".
	        "44.92.20.22 n9paw.ampr.org n9paw\n".
	        "44.92.20.23 n9oly.ampr.org n9oly\n".
	        "44.92.20.24 n9ncq.ampr.org n9ncq\n".
	        "44.92.20.30 n9nci.ampr.org n9nci\n".
	        "44.92.20.31 n9pav-2.ampr.org n9pav-2\n".
	        "44.92.20.32 kb9aln-5.ampr.org kb9aln-5\n".
	        "44.92.20.35 kb9mwr.ampr.org kb9mwr\n".
	        "44.92.20.36 n9ncq-5.ampr.org n9ncq-5\n".
	        "44.92.20.37 n9oly-5.ampr.org n9oly-5\n".
	        "44.92.20.38 kb9mwr-5.ampr.org kb9mwr-5\n".
	        "44.92.20.39 n9zda-5.ampr.org n9zda-5\n".
           "44.92.20.43 n9dkh.ampr.org n9dkh\n".
	        "44.92.2.11 ke9lz-1.ampr.org saber-ke9lz\n".
	        "# Door County 44.92.2.x\n".
	        "44.92.2.29 ke9lz-6.ampr.org ke9lz-6\n".
	        "44.92.2.30 ke9lz-7.ampr.org ke9lz-7\n".
	        "44.92.2.31 ke9lz-8.ampr.org ke9lz-8\n".
	        "44.92.2.48 w9aiq-1.ampr.org w9aiq-1\n".
	        "44.92.2.49 w9aiq-7.ampr.org w9aiq-7\n".
	        "# Appleton 44.92.18.x\n".
	        "44.92.18.1 n9bpo.ampr.org n9bpo\n".
	        "44.92.18.5 kb9byq-5.ampr.org kb9byq-5\n".
	        "44.92.18.6 kb9byq-6.ampr.org kb9byq-6\n".
	        "44.92.18.10 ka9jac.ampr.org ka9jac\n".
	        "44.92.18.11 ka9jac-6.ampr.org ka9jac-6\n".
	        "44.92.18.29 kb9byq.ampr.org kb9byq\n".
	        "44.92.18.31 kb9byq-3.ampr.org kb9byq-3\n".
	        "44.92.18.33 n9sgg.ampr.org n9sgg\n".
	        "44.92.18.34 n9rjz.ampr.org n9rjz\n".
	        "44.92.18.37 kb9eno.ampr.org kb9eno\n".
	        "44.92.18.42 kb9qwc.ampr.org kb9qwc\n".
	        "44.92.18.45 linux.kb9qwc.ampr.org linux-kb9qwc\n".
	        "# Manitowoc 44.92.22.x\n".
	        "44.92.22.1 n9ghe.ampr.org n9ghe\n".
	        "44.92.22.2 n9ghe-9.ampr.org n9ghe-9\n".
	        "44.92.22.3 n9ghe-8.ampr.org n9ghe-8\n".
	        "44.92.22.4 n9ghe-7.ampr.org n9ghe-7\n".
	        "# Shebogan 44.92.24.x\n".
	        "44.92.24.44 kg9bo.ampr.org kg9bo\n".
	        "# Wittenberg 44.92.31.x\n".
	        "44.92.31.1 k9aeg-5.ampr.org k9aeg-5\n".
	        "44.92.31.2 k9aeg-6.ampr.org k9aeg-6\n".
	        "44.92.31.6 n9wvd.ampr.org n9wvd\n".
	        "44.92.31.12 n9wbr.ampr.org n9wbr\n".
	        "# Marinette/Oconto County 44.92.25.x\n".
	        "44.92.25.4 ke9lk-8.ampr.org ke9lk-8\n".
	        "44.92.25.5 ke9lk-6.ampr.org ke9lk-6\n";
	close F;
}

rename "$ax25rcd.bak", "$ax25rcd";
chmod 0755, $ax25rcd, $ax25init;
chmod 0644, "$ax25root/axports", $hosts;
chdir "/etc/rc.d/rc3.d";
symlink "../init.d/ax25", "S90ax25";

print "\n$bld Done! $clr\n\n".
      "Use $ax25init (start|stop) to control the AX.25 services or ".
      "reboot\n\n";
