/* nhost.c 2.3 dd. aug 13 1992		(c) Copyright 1991,1992 Rob J. Nauta.
 * This module contains the findhost(), getsock() and opensock() functions.
 * findhost() returns the official name of a host, indicated by a name or
 * number. findhost2() returns a struct hostent *, and is meant to replace
 * findhost. getsock() returns a struct sockaddr_in *, with the relevant
 * fields filled with the internet number of the host. opensock() opens a
 * socket to a given port on a given host. */
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#ifndef lint
static char idstr[] = "@(#)nhost.c 2.1 91/11/20 RJN\n\
		(c) Copyright 1991 Fidelio Software. All rights reserved.\n";
#endif

struct hostent *
findhost2(host)			/* Find a real hostname for the argument */
char *host;
{
	struct hostent *hp;
	unsigned long num;

	if ((hp = gethostbyname(host)) == NULL) {
		num = inet_addr(host);	/* Try the number */
		if ((hp = gethostbyaddr(&num, sizeof(num), 0)) == NULL)
			return (NULL);
	}
	return (hp);
}

char *
findhost(host)
char *host;
{
	struct hostent *hp;

	if (hp = findhost2(host))
		return (hp->h_name);
	fprintf(stderr, "can't get adress for %s\n", host);
	return (NULL);
}

struct sockaddr_in *
getsock(arg)
char *arg;
{
	static struct sockaddr_in sin;
	static struct hostent *hp;

	sin.sin_addr.s_addr = inet_addr(arg);
	if (sin.sin_addr.s_addr != -1) {
		/* arg is aaa.bbb.ccc.ddd, so fill sin with data */
		sin.sin_family = AF_INET;
		return (&sin);
	}
	/* argument is probably a hostname */
	hp = gethostbyname(arg);
	if (hp) {
		/* Hostname lookup was successfull */
		sin.sin_family = hp->h_addrtype;
#if defined(h_addr)		/* In 4.3, this is a #define */
		memcpy((caddr_t) & sin.sin_addr,
		       hp->h_addr_list[0], hp->h_length);
#else				/* defined(h_addr) */
		memcpy((caddr_t) & sin.sin_addr,
		       hp->h_addr, hp->h_length);
#endif				/* defined(h_addr) */
		sin.sin_family = AF_INET;
		return (&sin);
	}
	fprintf(stderr, "Can't find %s !\n", arg);
	return (NULL);		/* Nothing found */
}

/* opensock - open a stream connection to a port on a host. Returns -1 on
 * failure, with errno set. */
opensock(hostname, portnum)
char *hostname;
int portnum;
{
	struct sockaddr_in *sp;
	int s;

	if ((sp = getsock(hostname)) == NULL)
		return (-1);	/* Unknown host */

	sp->sin_port = htons((u_short) portnum);
	if ((s = socket(sp->sin_family, SOCK_STREAM, 0)) < 0)
		return (-1);
	if (connect(s, sp, sizeof(*sp)) < 0) {
		close(s);
		return (-1);
	}
	return (s);		/* Success */
}
