package Freenet;

import java.lang.reflect.*;
import java.io.Serializable;

public class Address implements Serializable
{
  public String protocol;
  public ProtocolAddress address;

  public Address(String protocol, ProtocolAddress addr)
    {
      this.protocol = protocol;
      this.address = addr;
    }

  public Address(String str)
  {
    try
    {
    int i=str.indexOf('/');
    if(i==-1) throw new IllegalArgumentException();
    protocol=str.substring(0,i);
    Class c=Class.forName("Freenet."+protocol+"Address");
    Class[] carr={java.lang.String.class};
    Constructor con=c.getConstructor(carr);
    Object[] oarr={str.substring(i+1)};
    address=(ProtocolAddress)con.newInstance(oarr);
    }
    catch(Exception e) { throw new IllegalArgumentException(e.toString()); }
 }

  public String toString()
    {
      return protocol+"/"+address;
    }

  public int hashCode()
  {
    return toString().hashCode();
  }

    public ListeningAddress listenPart() {
	return new ListeningAddress(protocol,address.listenPart());
    }

  public boolean equals(Object o)
    {
	return ((o instanceof Address) &&
	       	(((Address) o).protocol.equals(protocol)) &&
	       	(((Address) o).address.equals(address)));

    }
}
