package Freenet;
import Freenet.support.*;
import java.io.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: java.io.* (JDK 1.1)
                    Callback (1.0)

 */

/**
 * This class creates a conduit between an InputStream and an 
 * OutputStream and when the feed method of this object is called
 * the InputStream will be fed into the output stream of this
 * object.
 *
 * @version 1.0
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class Conduit extends Thread
{
  InputStream in;
  OutputStream out;
  Callback cb;
    ByteCounter counter;

  /**
   * @param i The stream to read data from
   * @param o The stream to send data to
   **/
  public Conduit(InputStream i, OutputStream o)
    {
	this(i,o,null);
    }
  /**
   * @param i The stream to read data from
   * @param o The stream to send data to
   * @param counter The counter to count the bytes
   **/
    public Conduit(InputStream i, OutputStream o, ByteCounter counter) {
	this.in = i;
	this.out = o;
	this.counter = counter;
    }

   

  /**
   * Commences the transfer from Input to Output Streams asynchronously
   **/
  public void asyncFeed(Callback cb)
    {
      this.cb=cb;
      this.start();
    }

  /**
   * Transfer from Input to Output Streams, doesn't return until transfer
   * complete
   **/
  public void syncFeed()
    {
      this.run();
    }

  public void run()
    {
      byte[] buffer = new byte[512];
      int bytes_read;
      try
	{
	  for(;;)
	    {
	      bytes_read = in.read(buffer);
	      if (bytes_read == -1)
		{
		  if (cb != null)
		    cb.callback();
		  if (counter != null)
		      counter.finished();
		  return;
		}
	      out.write(buffer, 0, bytes_read);
	      if (counter != null)
		  counter.count(bytes_read);
	    }
	}
      catch (IOException e)
	{
	  Logger.log("Conduit.java",e.toString(),Logger.ERROR);
	}
      finally
	{
	  try
	    {
	      out.close();
              Logger.log("Conduit.java","Conduit finished",Logger.DEBUG);
	    }
	  catch (IOException e) {}
	}
      if (cb != null)
	cb.callback();
    }
}

