package Freenet;

import java.lang.reflect.*;

public class ConnectionFactory
{
  static public Connection connect(Address address) throws ConnectTimedOutException
  {
    try
    {
      Class c=Class.forName("Freenet."+address.protocol+"Connection");
      Class[] carr={Class.forName("Freenet."+address.protocol+"Address")};
      Constructor con=c.getConstructor(carr);
      Object[] aar={address.address};
      return (Connection)con.newInstance(aar);
    }
    catch(InvocationTargetException e)
    {
      Throwable f=e.getTargetException();
      if(f instanceof ConnectTimedOutException)
        throw new ConnectTimedOutException();
      else
        f.printStackTrace();
      return null;
    }
    catch(Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }
}




