package Freenet;
import Freenet.support.*;
import java.net.*;
import java.io.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * Allows the starting of a new thread to handle an incoming connection
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 * @author <a href="mailto:blanu@uts.cc.utexas.edu">Brandon Wiley</a>
 **/

public class ConnectionHandler extends Thread
{
  // Protected/Private Fields
  Connection c;
  MessageHandler mh;
  // Constructors
  public ConnectionHandler(Connection c, MessageHandler mh)
    {
      this.c = c;
      this.mh = mh;
    }
  // Public Methods
  public void run()
    {
      RawMessage m=null;

      try
	{
          if(c==null) System.out.println("No connection in ConnectionHandler.run()");
	  m = new RawMessage(c.in);
	  Logger.log("ConnectionHandler.java","Rawmessage:\n"+m,Logger.MINOR);
	}
      catch (InvalidMessageException e) {
	  c.close();
	  Logger.log("ConnectionHandler.java",e.toString(),Logger.MINOR);
	  return;
	  }
      catch (Exception e)
	{
	    c.close();
	  e.printStackTrace(System.out);
	  throw new RuntimeException("Can't process incoming connection)");
	}
      Message msg = MessageFactory.toMessage(m);
      Logger.log("ConnectionHandler.java","Message:\n"+msg,Logger.DEBUG);
      if (msg == null) return;
      // set the RecievedAt field 
      System.out.println(msg);
      msg.initSources(c.getMyAddress(),c.getPeerAddress(msg.source.listenPart()));
      mh.handle(msg);
      Logger.log("ConnectionHandler.java","Finished with message",Logger.DEBUGGING);
    }
}
