package Freenet;

import java.lang.reflect.*;
import Freenet.support.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * HandshakeFactory.java
 *
 * This object takes a RawMessage and converts it to the appropriate 
 * subclass of the Handshake class depending on the handshake.
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

public class HandshakeFactory
{
  public static Handshake toHandshake(RawMessage r)
    {
      try
      {
        Class c=Class.forName("Freenet.handshake."+r.messageType);
        Class[] carr={Freenet.RawMessage.class};
        Object[] oarr={r};
        Constructor con=c.getConstructor(carr);
	Handshake m=(Handshake)con.newInstance(oarr);
        return m;
      }
      catch(InvocationTargetException e) 
	{
	  Logger.log("HandshakeFactory.java","Handshake constructor threw exception:",Logger.ERROR);
	  e.getTargetException().printStackTrace(Logger.Lout);
	}
      catch(ClassNotFoundException e) {
	  Logger.log("HandshakeFactory.java","Unknown messagetype.",Logger.NORMAL);
      }
      catch(Exception e)
	{
	  e.printStackTrace(Logger.Lout);
	}
      return null;
    }
}







