package Freenet;

import java.io.Serializable;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Class (version)
                    Class (version)
                    ...
 */

/**
 * A generic interface to a key
 *
 * @version 1.0
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public interface Key extends Serializable
{
  /**
   * Compares two other keys to this one to determine which is closer
   * @param a The first key (must be of same type as this key)
   * @param b The second key (must be of same type as this key and a)
   * @return True if and only if a is closer to this key than b
   * @exception KeyException Thrown if a or b are not of same type
   **/
  public boolean compare(Key a, Key b) throws KeyException;

  public boolean equals(Object o);

  public int hashCode();
}
