package Freenet;

import java.lang.reflect.*;
import Freenet.support.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
 */

/**
 * MessageFactory.java
 *
 * This object takes a RawMessage and converts it to the appropriate 
 * subclass of the Message class depending on the message.
 *
 * @author Brandon Wiley (blanu@uts.cc.utexas.edu)
 * @author Ian Clarke (I.Clarke@strs.co.uk)
 **/

public class MessageFactory
{
  public static Message toMessage(RawMessage r)
    {
      try
      {
        Class c=Class.forName("Freenet.message."+r.messageType);
        Class[] carr={Freenet.RawMessage.class};
        Object[] oarr={r};
        Constructor con=c.getConstructor(carr);
	Message m=(Message)con.newInstance(oarr);
        return m;
      }
      catch(InvocationTargetException e) 
	{
	  Logger.log("MessageFactory.java","Message constructor threw exception:",Logger.ERROR);
	  e.getTargetException().printStackTrace(Logger.Lout);
	}
      catch(ClassNotFoundException e) {
	  Logger.log("MessageFactory.java","Unknown messagetype - "+e,Logger.NORMAL);
      }
      catch(Exception e)
	{
	  e.printStackTrace(Logger.Lout);
	}
      return null;
    }
}







