package Freenet;
import java.util.*;
import Freenet.support.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
 */

/**
 * This class handles incoming messages.
 *
 * @version $revision$
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class MessageHandler
{
  // Public Fields
  // Protected/Private Fields
  Node node;
  Hashtable objs;
  
    public static void main(String[] args)
    {
	System.out.println("Testing limitedHashtable");
	Hashtable t = new LimitedHashtable(3);
	t.put(new Integer(1), new String("one"));
	System.out.println(t.toString());
	t.put(new Integer(2), new String("two"));
	System.out.println(t.toString());
	t.put(new Integer(3), new String("three"));
	System.out.println(t.toString());
	t.put(new Integer(4), new String("four"));
	System.out.println(t.toString());
	t.put(new Integer(5), new String("five"));
	System.out.println(t.toString());
	t.put(new Integer(6), new String("six"));
	System.out.println(t.toString());
    }

  // Constructors

  /**
   * @param n The node that should be used to send messages
   *          and for which the datastore should be updated
   * @param m The number of message objects that will be
   *          remembered
   **/
  public MessageHandler(Node n, int m)
    {
      node = n;
      objs = new LimitedHashtable(m);
    }

  // Public Methods

  /**
   * Handle a message
   * @param message The message to handle
   **/
  public void handle(Message message) {
      try {
	  MessageMemory mm = (MessageMemory)objs.get(new Long(message.id));
	  if (mm != null) {
	      synchronized(mm) {
		  // We now delete this memory from the LimitedBinaryTree
		  objs.remove(new Long(message.id));
		  mm=message.received(node, mm);
		  if(mm!=null)
		      objs.put(new Long(message.id), mm);
	      }
	  } else {
	      mm=message.received(node, mm);
	      if(mm!=null)
		  objs.put(new Long(message.id), mm);      
	  }
      } catch(Exception e) {e.printStackTrace();}
  }

  // Protected/Private Methods
}

class LimitedHashtable extends Hashtable
{
    Object[] ar;
    int ptr = 0;
    public LimitedHashtable(int size)
    {
	super();
	ar = new Object[size];
    }

    public Object put(Object key, Object value)
    {
	if (ar[ptr] != null)
	    {
		remove(ar[ptr]);
	    }
	ar[ptr] = key;
	ptr++;
	if (ptr == ar.length)
	    {
		ptr = 0;
	    }
	return 	super.put(key,value);
    }

    public String toString()
    {
	return super.toString() + ", max: "+ar.length;
    }
}
