package Freenet;
import Freenet.support.*;
import Freenet.message.HandshakeRequest;
import java.util.*;
import java.net.*;
import java.io.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * This is a Wrapper object that contains the components of a Node in the
 * Adaptive Network.  It uses a Network object to communicate with other
 * Nodes in the Network.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 * @author <a href="mailto:blanu@uts.cc.utexas.edu">Brandon Wiley</a>
 **/

public class Node
{
    public static final String versionString = "1.1";
    public static Node n;
    public static Params params;
    public static boolean debug;
    public static int timePerHop;
    public static int connectTimeout;
    public static int handshakeTimeout;
    public static boolean tunneling;
    public static Ticker timer;
    public static Hashtable handshakes=new Hashtable();

    public static void main(String[] args)
    {
      try {
        Data.path = new File(".freenet");
        if (!Data.path.exists())
	    Data.path.mkdir();
        // load config file
        params = new Params(".freenetrc", args);

	String fname = params.getParam("logFile","NO");
	if (!fname.equalsIgnoreCase("NO")) {
	    try {
		Logger.logto(fname);
	    } catch (Exception e) {
		System.out.println("Writing to log failed");
	    }
	}
	
        // timer must be initialized before datastore so that datastore
	// can register an event to write it to disk periodically
        Node.timer = new Ticker(params.getlong("tickerTime",500));

        // set parameters
        // These should be taken from arguments or a config file
        n = new Node(params.getlong("diskCache", 500), 
		          params.getint("dataStoreSize", 500), 
			  params.getint("messageStoreSize", 500), 
			  new ListeningAddress
			      ("tcp/" + params.getint("listenPort", 0)));
        if (params.getParam("logging")==null)
            Logger.threshold = Logger.NORMAL;        
	else if (params.getParam("logging").equalsIgnoreCase("error"))
	    Logger.threshold = Logger.ERROR;
	else if (params.getParam("logging").equalsIgnoreCase("normal"))
	    Logger.threshold = Logger.NORMAL;
	else if (params.getParam("logging").equalsIgnoreCase("minor"))
	    Logger.threshold = Logger.MINOR;
	else if (params.getParam("logging").equalsIgnoreCase("debugging"))
	    Logger.threshold = Logger.DEBUGGING;

	timePerHop = params.getint("timePerHop",5000);
        tunneling = !((params.getParam("Tunnel", "YES")).equalsIgnoreCase("NO"));
        connectTimeout = params.getint("connectTimeout",30000);
        handshakeTimeout = params.getint("handshakeTimeout",30000);
        if (!tunneling)
	    Logger.log("Node.java","Tunneling turned off",Logger.DEBUGGING);

	if ((params.getParam("informRead").equalsIgnoreCase("yes") ||
	     (params.getParam("informWrite").equalsIgnoreCase("yes"))) &&
	    params.getParam("informUrl") != null)
	    {
		try
		    {
			HttpURLConnection c = (HttpURLConnection) 
			    (new URL(params.getParam("informUrl"))).
			    openConnection();
			c.setDoInput(true);
			c.setDoOutput(true);
			c.setUseCaches(true);
			if (params.getParam("informWrite").equalsIgnoreCase("yes"))
			    {
				c.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
				PrintWriter outStream = new PrintWriter(c.getOutputStream());
				outStream.print("port="+params.getParam("listenPort"));
				outStream.close();
			    }
			if (params.getParam("informRead").equalsIgnoreCase("yes"))
			    {
				InputStreamReader ir = new InputStreamReader(c.getInputStream());
				BufferedReader br = new BufferedReader(ir);
                                Hashtable at=new Hashtable();
				while(br.ready())
				    {
					StringKey tname;
					Random r = new Random();
					do
					    {
						tname = new StringKey("t"+Math.abs(r.nextInt() % 10000000));
					    } while (n.ds.searchRef(tname)!=null);
					String addrstr=br.readLine();
					addrstr=addrstr.trim();
					if(!addrstr.equals(""))
                                            at.put(addrstr, tname);
				    }
                                  Enumeration iterator=at.keys();
                                  while(iterator.hasMoreElements())
                                  {
                                    String addr=(String)iterator.nextElement();
                                    n.ds.put((StringKey)at.get(addr), new Address(addr), null);
                                  }
				ir.close();
			    }
			c.disconnect();
		    }
 		catch (Exception e)
	 	    {
		 	Logger.log("Node.java","Inform Connection failed:"+e, 
 			 	   Logger.ERROR);
		    } 
	    }

        try
            {
                BufferedReader br=new BufferedReader(new FileReader("nodes.config"));
                while(br.ready())
                    {
                        StringKey tname;
                        Random r = new Random();
                        do
                            {
                                tname = new StringKey("t"+Math.abs(r.nextInt() % 10000000));
                            } while (n.ds.searchRef(tname)!=null);
                        String addrstr=br.readLine();
			addrstr=addrstr.trim();
			if(!addrstr.equals(""))
                          n.ds.put(tname, new Address(addrstr), null);
                    }
            }
        catch(IOException e) {}
        
        n.acceptConnections();
      }
      catch(Exception e) {e.printStackTrace();}
    }

    public ListeningAddress myAddress;
    public MessageHandler mh;
    public DataStore ds;
    public Listener listener;

    public Node(ListeningAddress myAddress) {    	
	this.myAddress = myAddress;
    	this.listener = ListenerFactory.listen(myAddress);
    }

    public Node(long dataLen, int dataStoreSz, int messStoreSz, ListeningAddress lstaddr)
    {
        mh = new MessageHandler(this, messStoreSz);
        ds = DataStore.makeDataStore(this, ".freenet/store", dataLen, dataStoreSz);
	myAddress = lstaddr;
        listener = ListenerFactory.listen(myAddress);
	Logger.log("Node.java","Node running on "+listener,Logger.NORMAL);
    }
    
    public void acceptConnections()
    {
      Connection conn;
      RawMessage m;
      ConnectionHandler c;
      while(true)
        {
          try
            {
              conn = listener.accept();
	      Logger.log("Node.java","Accepted connection:"+conn,Logger.MINOR);
            }
          catch (IOException e)
            {
              throw new RuntimeException("Problem accepting next connection");
            }
          c = new ConnectionHandler(conn, mh);
          c.start();
        }
    }

  /**
   * Send the message using the appropriate protocol
   **/
    public void sendMessage(Message m, Address destination) throws SendFailedException
    {
	sendMessage(m, destination, null, null);
    }

    /**
     * Send the message using the appropriate protocol streaming
     * the actual data through the SplitOutputStream tunnel
     **/

  public void sendMessage(Message m, Address destination, SplitOutputStream datatunnel) throws SendFailedException
    {
	sendMessage(m, destination, datatunnel, null);
    }

    /**
     * Send the message using the appropriate protocol, streaming
     * the actual data through the SplitOutputStream tunnel, and
     * counting the bytes sent with ByteCounter
     **/

    public void sendMessage(Message m, Address destination, SplitOutputStream datatunnel, ByteCounter count) throws SendFailedException
    {

      if(destination==null || m == null) return;
      if(!(m instanceof Handshake))
        if (!getHandshake(destination, true))
	  throw new SendFailedException(destination);
      Connection c;
      try {
	  c = ConnectionFactory.connect(destination);
      } 
      catch(ConnectTimedOutException e)
      {
        Logger.log("Node.java","Connection attempt timed out",Logger.MINOR);
	throw new SendFailedException(destination);
      }
      catch(Exception e) {
	  Logger.log("Node.java","Connection Error: " + e,Logger.ERROR);
	  throw new SendFailedException(destination);
      }
      if(c == null)
	  throw new SendFailedException(destination);
      
      // let the message do last minute changes
      try {
	  m.sending(this, destination, c.getMyAddress(myAddress));
      } catch (SendFailedException sfe) {
	  c.close();
	  throw sfe;
      }

      RawMessage raw=m.toRawMessage();
      Logger.log("Node.java",raw.messageType+" -> "+destination,Logger.NORMAL);
      try {
	  raw.writeMessage(c.out);
      } catch (IOException e) {
	  throw new SendFailedException(destination);
      }

      InputStream data = raw.getTrailing();
      if (data != null) {
	  if (datatunnel!=null) {
	      datatunnel.addOutput(c.out,
				   new ConnectionCallback(c));
	      (new Conduit(data, datatunnel, count)).asyncFeed(datatunnel);
	  } else {
	      (new Conduit(data, c.out, count)).asyncFeed(new ConnectionCallback(c));
	  }
      } else {
	  c.close();
      }
    }

  public boolean getHandshake(Address addr, boolean wait)
  {
    Date d=(Date)Node.handshakes.get(addr);
    if(d!=null)
    {
      if((d.getTime()+10000000) < new Date().getTime())
      {
        Node.handshakes.remove(addr);
        d=null;
      }
      else
        return true;
    }
    if(d==null)
    {
      HandshakeRequest hr=new HandshakeRequest(new Random().nextLong());
      try { sendMessage(hr, addr); }
      catch(SendFailedException e) {Logger.log("Node.java","Couldn't send handshake request",Logger.MINOR); return false;}
    }
    int x=0;
    if(wait)
      try { while((x<10)&&(d==null)) {Thread.currentThread().sleep(1000); d=(Date)Node.handshakes.get(addr);} }
      catch(InterruptedException e) {}
    Logger.log("Node.java","Done waiting for handshake",Logger.DEBUG);
    return d!=null;
  }
}

class ConnectionCallback implements Callback
{
    private Connection c;

    public ConnectionCallback(Connection c)
    {
	this.c = c;
    }

    public void callback()
    {
	c.close();
    }
}
