package Freenet;

import Freenet.support.*;
import java.util.*;
import java.io.*;

/**
 * Stores Freenet parameters
 **/
public class Params
{
  Hashtable params = new Hashtable();
  private Properties props = new Properties();

  public Params()
  {
  }

    public Params(String filename) throws FileNotFoundException
    {
	this(filename, null);
    }

    public Params(String[] args)
    {
	this(null, args);
    }

  public Params(String filename, String[] args)
  {
    super();
    if (filename != null)
	{
	    try
		{
		    readParams(filename);
		}
	    catch (FileNotFoundException e)
		{
		    Logger.log("Params.java", "Couldn't load config file", Logger.ERROR);
		}
	}
    if (args != null)
	{
	    for (int x=0; x<args.length; x++)
		{
		    if (args[x] != null)
			{
			    if (args[x].charAt(0) == '-')
				{
				    setParam(args[x].substring(1), args[x+1]);
				    x++;
				}
			}
		}
	}
  }

  public void readParams(String filename) throws FileNotFoundException
  {
    FileInputStream in=new FileInputStream(filename);

    try
    {
      props.load(in);
    }
    catch(IOException e)
    {
      Logger.log("Params.java","Could not read config file",Logger.ERROR);
      return;
    }
    Enumeration iterator=props.propertyNames();
    while(iterator.hasMoreElements())
    {
      String name=(String)iterator.nextElement();
      params.put(name, props.getProperty(name));
    }
  }

  public void setParam(String name, String value)
  {
      Logger.log("Params.java", "set \""+name+"\" to \""+value+"\"", Logger.MINOR);
      params.put(name, value);
  }

  public String getParam(String name, String def)
  {
    String temp=getParam(name);
    if(temp==null) return def;
    else return temp;
  }

  public String getParam(String name)
  {
    String r = (String)params.get(name);
    if (r == null)
	{
	    Logger.log("Params.java", 
		       "Can't find value for parameter '"+name+"'",
		       Logger.ERROR);
	}
    return r;
  }

  public long getlong(String name, long def)
  {
    String temp=getParam(name);
    if(temp==null) return def;
    else return getlong(name);
  }

  public long getlong(String name)
  {
    return (new Long(getParam(name))).longValue();
  }

  public int getint(String name, int def)
  {
    String temp=getParam(name);
    if(temp==null) return def;
    else return getint(name);
  }

  public int getint(String name)
  {
    return (new Integer(getParam(name))).intValue();
  }

  public short getshort(String name, short def)
  {
    String temp=getParam(name);
    if(temp==null) return def;
    else return getshort(name);
  }

  public short getshort(String name)
  {
    return (new Short(getParam(name))).shortValue();
  }

  public void writeParams(String filename)
  {
    try
    {
    PrintWriter fw=new PrintWriter(new FileWriter(filename));

    Enumeration iterator=params.keys();
    while(iterator.hasMoreElements())
    {
      String name=(String)iterator.nextElement();
      fw.println(name+"="+params.get(name));
    }
    fw.close();
    }
    catch(IOException e)
    {
      Logger.log("Params.java","Could not write to config file",Logger.ERROR);
    }
  }
}
