package Freenet.client;
import Freenet.*;
import Freenet.support.*;
import Freenet.message.*;
import java.util.*;
import java.io.*;

/**
 * A class permitting the sending and receiving of messages to and
 * from a Freenet node.
 **/
public class Client
{
    protected Listener listener;
    protected Hashtable ht = new Hashtable();
    protected CallBack defaultCallBack = null;

    /**
     * Creates a new Client listening to a random port
     * @param defCB A default callback which will be executed if
     *              an unrecognised message is received.
     **/
    public Client(CallBack defCB)
    {
	this();
	defaultCallBack = defCB;
    }

    /**
     * Creates a new client listening to a specified port
     * @param port The port to listen to
     * @param defCB A default callback which will be executed if
     *              an unrecognised message is received.
     **/
    public Client(int port, CallBack defCB)
    {
	this(port);
	defaultCallBack = defCB;
    }
    /**
     * Creates a new Client listening to a random port
     **/
    public Client()
    {
      this(0);
    }
    
    /**
     * Creates a new client listening to a specified port
     **/
    public Client(int listenPort)
    {
	listener = ListenerFactory.listen(new ListeningAddress("tcp/"+
							       listenPort));
	listenerThread lt = new listenerThread(ht);
	lt.start();
    }

    /**
     * Sends a message
     * @param m The message to send
     * @param a The address to send the message to
     **/
    public void sendMessage(Message m, Address a)
	throws SendFailedException
    {
	sendMessage(m, a, null);
    }

    /**
     * Sends a message
     * @param m The message to send
     * @param a The address to send the message to
     * @param cb A callback which will be called with any message
     *           which is received with the same ID as this
     *           message.
     **/
    public void sendMessage(Message m, Address d, CallBack cb)
	throws SendFailedException
    {
	Connection c;
	try
	    {
		c = ConnectionFactory.connect(d);
	    }
	catch(Exception e)
	    {
		throw new SendFailedException(d);
	    }
	if (!getHandshake(c.in))
	    {
		throw new SendFailedException(d);
	    }
	m.source = c.getMyAddress();
	RawMessage rm = m.toRawMessage();
	try
	    {
		rm.writeMessage(c.out);
	    }
	catch (IOException e)
	    {
		c.close();
		throw new SendFailedException(d);
	    }
	c.close();
	// Register the callback
	if (cb != null)
	    {
		ht.put(new Long(m.id), cb);
	    }

    }
    
    protected boolean getHandshake(InputStream in)
    {
	try{
	} catch(IOException e) {return false;}
    }

    /**
     * An interface to handlers for received messages
     **/
    public interface CallBack
    {
	/**
	 * Called when a message is received
	 * @param The received message
	 **/
	public abstract void callBack(Message m);
    }

    protected class listenerThread extends Thread 
    {
	Hashtable ht;

	public listenerThread(Hashtable ht)
	{
	    this.ht = ht;
	}

	public void run()
	{
	    Connection conn;
	    RawMessage m;
	    CHandler c;
	    while(true)
		{
		    try
			{
			    conn = listener.accept();
			    CHandler ch = new CHandler(conn, ht);
			    ch.start();
			}
		    catch (IOException e)
			{
			    throw new RuntimeException("Problem accepting next connection");
			}
		}
	}
    }
    
    protected class CHandler extends Thread
    {
	Connection c;
	Hashtable ht;

	public CHandler(Connection c, Hashtable ht)
	{
	    this.c = c;
	}

	public void run()
	{
	    RawMessage m = null;
	    
	    try
		{
		    // Send handshake
		    // **

                    // Get message
		    m = new RawMessage(c.in);
		}
	    catch (InvalidMessageException e) {
		c.close();
		return;
	    }
	    catch (Exception e)
		{
		    c.close();
		    e.printStackTrace(System.out);
		    throw new RuntimeException("Can't process incoming connection)");
		}
	    Message msg = MessageFactory.toMessage(m);

	    Object cb = ht.get(new Long(msg.id));
	    if (cb instanceof CallBack)
		((CallBack) cb).callBack(msg);
	    else if (defaultCallBack != null)
		defaultCallBack.callBack(msg);
	}
    }
}
