
package Freenet.client;
import java.io.*;
import Freenet.*;
import Freenet.support.*;
import Freenet.message.*;

public class ClientNode extends Node
{

    public ClientNode(ListeningAddress myAddress)
    {
	super(myAddress);
    }

    public Message acceptMessage() throws InvalidMessageException
    {
	try {
	    Connection c=listener.accept();
	    RawMessage raw=new RawMessage(c.in);
	    Message msg = MessageFactory.toMessage(raw);
	    return msg;
	} catch(IOException e) {
	    throw new InvalidMessageException("Broken response");
	}
    }

    public void checkid(Message msg, long id) throws InvalidMessageException
    {
	    if (msg == null || msg.id != id)
		throw new InvalidMessageException("Wrong id on response message");
    }

    public Handshake acceptHandshake() throws InvalidMessageException
    {
	try {
	    Connection c=listener.accept();
	    RawMessage raw=new RawMessage(c.in);
	    Message msg = MessageFactory.toMessage(raw);
	    if (msg == null || !(msg instanceof Handshake))
		throw new InvalidMessageException("Wrong id on response handshake");
	    return (Handshake)msg;
	} catch(IOException e) {
	    throw new InvalidMessageException("Broken handshake");
	}
    }
}
