package Freenet.client;
import Freenet.*;
import Freenet.support.*;
public class DotCounter implements ByteCounter
{
    long perdot; 
    long bytes = 0;
    long total = 0;
    long started = 0;

    public DotCounter(long perdot) {
	this.perdot = perdot; 
    }

    public long getTotal()
    {
      return total;
    }

    public void count(int n) {

	if (started == 0)
	    started = System.currentTimeMillis();
	bytes += n;
	total += n;

	if (bytes >= perdot) {
	    System.out.print(".");
	    bytes = bytes % perdot;
	}

    }

    public void finished() {
	long delta = System.currentTimeMillis() - started;
	if (delta <= 0 )
		delta = 1;
	double rate = total/delta * 1.024;
	System.out.println("\nFinished loading " + Double.toString(total) + " bytes at " + rate + " kB/s");
	    
    }
}
