package Freenet.client;
import Freenet.*;
import Freenet.message.*;
import java.util.*;
import java.io.*;
import javax.swing.*;
import java.awt.*;
import javax.swing.event.*;
import java.awt.event.*;

public class GUI
{
    public static ImageIcon icon = new ImageIcon("pixmaps/fn16x16.gif");

    protected static String version = "0.1";
    protected static JTextArea log;
    protected static JFrame main;
    protected static JDesktopPane desktop;
    protected static Listener listener;
    protected static int listenPort;
    protected static Hashtable messageCBs = new Hashtable();

    public static void main(String[] args)
    {
	main = new JFrame("Freenet Client "+version);
	main.setIconImage(icon.getImage());
	Container c = main.getContentPane();
	
	initMenuBar();
	desktop = new JDesktopPane();
	c.add(desktop);
	initEventLog();
	class WinHandler extends WindowAdapter
	{
	    public void windowClosing(WindowEvent evt)
	    {
		System.exit(0);
	    }
	}
	main.addWindowListener(new WinHandler());
	main.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
	main.setSize(600, 500);
	main.show();
	startListener();
    }
    
    public static void startListener()
    {
	Random r = new Random();
	int giveup = 10;
	while (true)
	    {
		listenPort = Math.abs((r.nextInt() % 10000))+10000;
		try
		    {
			listener = ListenerFactory.listen(new ListeningAddress("tcp/"+listenPort));
			break;
		    }
		catch (Exception e) 
		    {
			giveup--;
			if (giveup == 0)
			    throw new RuntimeException("Failed to bind to any of 10 ports, giving up");
			log.append("Failed to bind to random port "+listenPort+", trying another\n");
		    }
	    }
	log.append("Listener started on port "+listenPort+"\n");
    }


    public static void acceptConnections()
    {
	Connection conn;

	while(true)
	    {
		try
		    {
			conn = listener.accept();
			new HandleConn(conn);
		    }
		catch (IOException e)
		    {
			throw new RuntimeException("Problem accepting next connection: "+e);
		    }
	    }
    }

    public static void initMenuBar()
    {
	JMenuBar menu = new JMenuBar();
	JMenu messageMenu = new JMenu("Messages");
	messageMenu.add(new EditMessageAction(new RequestMessageEditor()));
	messageMenu.add(new EditMessageAction(new InsertMessageEditor()));
	menu.add(messageMenu);
	JMenu settingsMenu = new JMenu("Settings");
	settingsMenu.add(new JMenuItem("Default Server"));
	menu.add(settingsMenu);
	JMenu helpMenu = new JMenu("Help");
	menu.add(helpMenu);
	main.setJMenuBar(menu);
    }
    
    public static void initEventLog()
    {
	JInternalFrame eventLog = new JInternalFrame("Event Log",
						     true,
						     false,
						     true,
						     true);
	eventLog.setFrameIcon(icon);
	JPanel panel = new JPanel(new GridLayout(1,1), true);
	log = new JTextArea("Started Freenet Client V"+version+"\n");
	log.setEditable(false);
	panel.add(log);
	JScrollPane scrollPane = new JScrollPane(panel,
						 JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
						 JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	eventLog.getContentPane().add(scrollPane);
	eventLog.setLocation(5,300);
	eventLog.setSize(200,100);
	desktop.add(eventLog);
    }
    
    class NewRequestAction extends AbstractAction
    {
	public void actionPerformed(ActionEvent aw)
	{
	    
	}
    }
}

interface MessageCB
{
    public abstract void received(Message m);
}

class HandleConn extends Thread
{
    Connection conn;
    JTextArea log;
    Hashtable messageCBs;

    public HandleConn(Connection conn)
    {
	this.conn = conn;
	start();
    }
    
    public void run()
    {
	RawMessage m = null;
	try
	    {
		m = new RawMessage(conn.in);
		Message msg = MessageFactory.toMessage(m);
		msg.initSources(conn.getMyAddress(),conn.getPeerAddress(msg.source.listenPart()));
		GUI.log.append("Received "+m.messageType+" message with ID "+msg.id+"\n");
		try
		    {
			((MessageCB) GUI.messageCBs.get(new Long(msg.id))).received(msg);
		    }
		catch (Exception e)
		    {
			GUI.log.append("Failed to handle message correctly\n");
		    }
	    }
	catch (Exception e)
	    {
		GUI.log.append("Problem processing incoming connection\n");
	    }
    }
}

class EditMessageAction extends AbstractAction
{
    MessageEditor me;
    public EditMessageAction(MessageEditor me)
    {
	super(me.getName());
	this.me = me;

    }

    public void actionPerformed(ActionEvent e)
    {
	me.display();
    }
}

class TabbedPaneListener implements ChangeListener 
{
    int i = -1;
    public void stateChanged(ChangeEvent ce)
    {
	JTabbedPane tp = (JTabbedPane) ce.getSource();
	if (i == -1 || i != tp.getSelectedIndex())
	    {
		tp.setEnabledAt(tp.getSelectedIndex(), false);
		if (i != -1)
		    tp.setEnabledAt(i, true);
	    }
	i = tp.getSelectedIndex();
    }
}

abstract class MessageEditor
{
    public abstract String getName();
    public abstract Message getMessage();

    public void display()
    {
	JInternalFrame iFr = new JInternalFrame(getName(),
						true,
						true,
						true,
						true);
	iFr.setFrameIcon(GUI.icon);
	Container c = iFr.getContentPane();
	JTabbedPane tp = new JTabbedPane();
	JPanel editPanel = new JPanel();
	editPanel.setLayout(new BoxLayout(editPanel, BoxLayout.Y_AXIS));
	JPanel advancedPanel = new JPanel();
        advancedPanel.setLayout(new BoxLayout(advancedPanel, BoxLayout.Y_AXIS));
	Box servIPB = Box.createHorizontalBox();
	servIPB.add(Box.createHorizontalGlue());
        JTextField servIPtf = new JTextField();
	servIPB.add(new JLabel("Server Name"));
	servIPB.add(servIPtf);
	Box servPB = Box.createHorizontalBox();
	servPB.add(Box.createHorizontalGlue());
        JTextField servPtf = new JTextField();
	servPB.add(new JLabel("Server Port"));
	servPB.add(servPtf);
	advancedPanel.add(Box.createVerticalGlue());
	advancedPanel.add(servIPB);
	advancedPanel.add(Box.createVerticalGlue());
	advancedPanel.add(servPB);
	advancedPanel.add(Box.createVerticalGlue());
	tp.addTab("Edit", editPanel);
	tp.addTab("Advanced", advancedPanel);
	tp.addChangeListener(new TabbedPaneListener());
	c.add(tp);

	Box sendBox = Box.createHorizontalBox();
	sendBox.add(Box.createHorizontalGlue());
	sendBox.add(new JButton("Send Message"));
	sendBox.add(Box.createHorizontalGlue());
	c.add(sendBox, BorderLayout.SOUTH);
	iFr.setLocation(10,10);
	iFr.setSize(300,150);
	GUI.desktop.add(iFr);
	try
	    {
		iFr.setSelected(true);
	    }
	catch (Exception e) {}
    }
}

class RequestMessageEditor extends MessageEditor
{
    protected DataRequest msg;

    public String getName()
    {
	return "Request Data";
    }

    public Message getMessage()
    {
	return msg;
    }
}

class InsertMessageEditor extends MessageEditor
{
    protected DataInsert msg;

    public String getName()
    {
	return "Insert Data";
    }

    public Message getMessage()
    {
	return msg;
    }

}
