
package Freenet.client;
import java.io.*;
import java.math.*;
import java.util.*;
import Freenet.*;
import Freenet.crypt.*;
import Freenet.support.*;
import Freenet.message.*;

public class InsertClient
{
    private Address nodeAddress;
    private ListeningAddress myAddress;
    private long hopsToLive;
    private long startDepth;
    
    public ClientNode cn;

    static public void main(String[] args)
    {
	if(args.length<5)
	    {
		System.out.println("usage: insert port address key filename hops-to-live");
		System.out.println("ex.: insert 10010 tcp/localhost:19114 freenet/1.0/insert Insert.java 256");
		return;
	    }

	ListeningAddress lstaddr=new ListeningAddress("tcp/" + args[0]);
	Address addr=new Address(args[1]);

	SHA1 sha = new SHA1(true);
	Key key=new StringKey(sha.doHash(args[2]));
	String fname=args[3];
	long htl = Long.parseLong(args[4]);

        Node.connectTimeout=10000;
        Node.handshakeTimeout=10000;
        Node.timer=new Ticker(500);
   
	InsertClient ic = new InsertClient(addr, lstaddr, htl, (Math.abs((new Random()).nextLong()) % 30));
	
	InputStream in;
	
	try {
	    in = new FileInputStream(fname);
            BigInteger length = new BigInteger(new Long(new File(fname).length()).toString());
            ic.getHandshake();
	    ic.insert(key, in, length, new DotCounter(1024));
        }
        catch(BadHandshakeException e)
        {
          System.out.println("Bad handshake");
          return;
	} catch (IOException ioe) {
	    System.out.println("Could not open file");
	    return;
	} catch (SendFailedException sfe) {
	    System.out.println("Sending insert failed, try a different node");
       	    return;
	} catch (ClientException ce) {
	    if (ce.msg instanceof RequestFailed) {
		System.out.println("The insert reached all reachable nodes before timing out."); 
	    } else if (ce.msg instanceof DataReply) {
		System.out.println("Key collision, insert again under a different key.");
	    } else {
		System.out.println("Recieved unknown reply.");
	    }
	    return;
	}
    }

    public InsertClient(Address addr, ListeningAddress myAddr, long htl, long dpth)
    {

	myAddress = myAddr;
	nodeAddress = addr;
	hopsToLive = htl;
	startDepth = dpth;

	cn = new ClientNode(myAddr);

    }

    public void getHandshake() throws BadHandshakeException
    {
            HandshakeReply shake=null;
            if(!cn.getHandshake(nodeAddress,false))
            {
              try { shake=(HandshakeReply)cn.acceptHandshake(); if(shake==null) throw new InvalidMessageException("Bad handshake"); }
              catch(InvalidMessageException e)
              {
                System.out.println("Could not get handshake from node");
                throw new BadHandshakeException();
              }
              if(!shake.check())
              {
                System.out.println("Node is not compatible with client");
                throw new BadHandshakeException();
              }
            }
            Node.handshakes.put(nodeAddress,new Date());
    }

    public void insert(Key key, InputStream in, BigInteger length, ByteCounter counter) throws ClientException, SendFailedException, BadHandshakeException
    {
	long id = (new Random()).nextLong();
	InsertRequest ir=new InsertRequest(id, hopsToLive, startDepth, key);
	
	Message response = null;

	cn.sendMessage(ir, nodeAddress, null);

	boolean failed;
	do {
	    failed = false;
	    try {
		response = cn.acceptMessage();
	    } catch(InvalidMessageException e) {
		Logger.log("client/InsertClient","Got broken response:" + e,Logger.MINOR);
		failed = true;
	    }
	    if (response instanceof QueryRestarted) {
		Logger.log("client/RequestClient","The request got stuck on a broken node but has been restarted at a depth of " + response.depth,Logger.MINOR);
		failed = true;
	    }
            else if (response instanceof HandshakeRequest)
            {
              Logger.log("client/InsertClient.java","Node requested a handshake",Logger.MINOR);
              response.received(cn, null);
              failed=true;
            }
            else
            {
              try { cn.checkid(response, ir.id); }
              catch(InvalidMessageException e)
              {
                Logger.log("client/RequestClient","Got broken response:" + e, Logger.MINOR);
                failed=true;
              }
            }
	} while (failed);

	if (!(response instanceof InsertReply)) {
	    throw new ClientException(response);
	} else {
	    DataInsert di = new DataInsert(id, hopsToLive, startDepth, nodeAddress);
    	    di.length = length;
	    di.in = in;
	    cn.sendMessage(di, nodeAddress, null, counter);
	}
    }
}
