package Freenet.client;

/**
 * Zips and unzips strings
 **/
public class Zipper
{
    public static void main(String[] args)
    {
	if (args.length != 1)
	    {
		System.out.println("Usage java Freenet.client.Zipper string");
	    }
	else
	    {
		String[] oz = unzip(args[0], 2);
		System.out.println(zip(oz));
	    }
    }
    
    /**
     * unzips a string into parts parts
     * @param str The string to unzip
     * @param parts The number of parts to unzip it into
     * @return The parts that the string has been unzipped into
     **/

    public static String[] unzip(String str, int parts)
    {
	StringBuffer[] stra = new StringBuffer[parts];
	char[] strC = str.toCharArray();
	for (int x=1; x<strC.length; x++)
	    {
		strC[x] ^=  strC[x-1];
	    }

	for (int x=0; x<stra.length; x++)
	{
	    stra[x] = new StringBuffer(str.length() / (parts));
	}
	int pos = 0;
	boolean fl = false;
	while(!fl)
	{
		for (int x=0; x<stra.length; x++)
		    {
			try
			    {
				    stra[x].append(strC[pos]);
			    }
			catch (ArrayIndexOutOfBoundsException e)
			    {
				fl = true;
				break;
			    }
			pos++;
		    }
	}
	String[] ret = new String[parts];
	for (int x=0; x<ret.length; x++)
	{
	    ret[x] = stra[x].toString();
	}
	return ret;
    }

    /**
     * Zips a string back together
     * @param stra An array of the component strings
     * @return The complete string
     **/
    public static String zip(String[] stra)
    {
	char[] ret;
	int strl = 0;
	for (int x=0; x<stra.length; x++)
	    {
		strl += stra[x].length();
	    }
	ret = new char[strl];
	boolean fl = false;
	int posO = 0;
	int posI = 0;
	while(!fl)
	    {
		for (int x=0; x<stra.length; x++)
		    {
			try
			    {
				ret[posO] = stra[x].charAt(posI);
				posO++;
			    }
			catch (IndexOutOfBoundsException e)
			    {
				fl = true;
				break;
			    }
		    }
		posI++;
	    }
	for (int x=ret.length-1; x>0; x--)
	    {
		ret[x] ^= ret[x-1];
	    }
	return new String(ret);
    }
}

