#!/usr/bin/perl -w
#
# Freenet CGI Request Client v0.0.4
#
# Copyright (C) 1999, 2000 Steven Hazel
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# see http://freenet.sourceforge.net/ for more info on Freenet
#

use strict;
use Socket;

my $FREENETPROTO = "1.1";
my $DEFAULTNODE = "localhost";
my $DEFAULTPORT = 19114;
my $DEFAULTHOPS = 5;
my $DEFAULTDL = 5;
my $DEFAULTDH = 30;
my $DEFAULTHASH = "SHA1";

my ($remote,$port, $iaddr, $paddr, $proto, $line, $insert, $request, $myhost, $myport, $key, $hop, $message, $id, $pid, $pair, $name, $value, $buffer, $depth, $mysockaddr, $sendport, $paddr2, $dl, $dh);

sub blurb {
    print "Content-type: text/plain\n\n";
    print "Freenet CGI Request Client v0.0.4\n\n";
    print "Copyright (C) 1999, 2000 Steven Hazel\n\n";
    print "see http://freenet.on.openproject.net for more info on Freenet\n";
    exit;
}

# grab anything sent to this script via POST or GET
# and put it in a mapping called $FORM
$buffer = "";
if (lc(defined($ENV{'REQUEST_METHOD'})) eq "get") { $buffer = defined($ENV{'QUERY_STRING'}); }
else { read(STDIN, $buffer, defined($ENV{'CONTENT_LENGTH'})); }

my @nvpairs = split(/&/, $buffer);
my %FORM = ();
foreach $pair (@nvpairs)
{
	($name, $value) = split(/=/, $pair); 

	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$name =~ tr/+/ /;
	$name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

        $FORM{$name}=$value;
}


$dh = $DEFAULTDH;
$dl = $DEFAULTDL;
$remote = $DEFAULTNODE;
$port = $FORM{'port'} || $DEFAULTPORT;
$hop = $FORM{'hop'} || $DEFAULTHOPS;

$key = $ENV{'PATH_INFO'};
$key = substr($key, 1);
$key =~ tr/+/ /;
$key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

$key || blurb;





$message = "DataRequest\n";

chop($myhost = `hostname`);
$myhost = inet_ntoa(scalar(gethostbyname($myhost)));
$myport = 11111;

$message .= "Source=tcp/$myhost:$myport\n";

$message .= "SearchKey=$key\n";
$id = "";
for (1..16) { $id = $id . sprintf("%x",int(rand(16))) };
$message .= "UniqueID=$id\n";
$message .= "HopsToLive=$hop\n";
$depth = int(rand(25)) +4;
$message .= "Depth=$depth\n";

if ($port =~ /\D/) { $port = getservbyname($port, 'tcp') }
die "No port" unless $port;
$iaddr   = inet_aton($remote) || die "no host: $remote";
$paddr   = sockaddr_in($port, $iaddr);
$proto   = getprotobyname('tcp');





# start listening for the impending DataReply connection, so we can be
# sure not to miss it.
socket(Server, PF_INET, SOCK_STREAM, $proto) || die "socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, pack("l", 1)) || die "setsockopt: $!";
until (bind(Server, sockaddr_in(( $myport = int(rand(32768-1024)) + 1025), INADDR_ANY))) {;}
listen(Server,SOMAXCONN) || die "listen: $!";





# now open the server and send the HandshakeRequest
socket(SOCK, PF_INET, SOCK_STREAM, $proto)  || die "socket: $!";
connect(SOCK, $paddr) || die "connect: $!";

# get the local host from the socket
$mysockaddr = getsockname(SOCK);
($sendport, $myhost) = unpack_sockaddr_in($mysockaddr);
$myhost = gethostbyaddr($myhost, AF_INET); 

# use /dev/random if possible
if (open(RAND,"/dev/random")) {
  read RAND, $id, 8;
  $id = pack("a16",unpack("h16",$id));
} else {
  $id = '';
  for (1..16) {$id .= sprintf("%x",int(rand(16)))}
}
substr($id,0,1) = '1' if substr($id,0,1) =~ "0";

# assemble handshake message

$message = "HandshakeRequest\n";
$message .= "Source=tcp/$myhost:$myport\n";
$message .= "UniqueID=$id\n";
$message .= "Depth=1\n";
$message .= "HopsToLive=1\n";
$message .= "EndMessage\n";

print SOCK $message;
close (SOCK) || die "close: $!";

# here i need to handle a handshake reply
for ( ; $paddr2 = accept(Client,Server); close Client) {
    
    my($sourceport,$sourceaddress) = unpack_sockaddr_in($paddr2);
    if ($iaddr ne $sourceaddress) {
	next;
    }

    my $messagetype = <Client>;
    my(%fields, $field);      # read field values
    while (defined($field = <Client>) && ($field  =~ /\=/)) {
	my($fieldname, $fieldvalue) = split('=',$field);
	chop $fieldvalue;      #dump \n at the end of every field
	$fields{$fieldname} = $fieldvalue;
    };

    if ($messagetype =~ /HandshakeReply/) {
	if ( $fields{'Version'} != "$FREENETPROTO" ) {
	    print "Content-type: text/plain\n\n";
	    print "Server running version $fields{'Version'}, expected $FREENETPROTO.";
	    exit;
	}
	last;
    } else {
	print "Content-type: text/plain\n\n";
	print "Received invalid response.";
	exit;
    }
}




# now open the server socket to send the DataRequest
socket(SOCK, PF_INET, SOCK_STREAM, $proto)  || die "socket: $!";
connect(SOCK, $paddr) || die "connect: $!";

# assemble next message

$message = "DataRequest\n";

$message .= "Source=tcp/$myhost:$myport\n";

if ($DEFAULTHASH eq 'SHA1') {
    $key = sha1hex($key);
}
$message .= "SearchKey=$key\n";


# Change $id to be different
if(substr($id,0,1) =~ "1") {
  substr($id,0,1) = '2';
} else {
  substr($id,0,1) = '1';
}
$message .= "UniqueID=$id\n";
$message .= "Depth=" . (int(rand($dh - $dl + 1)) + $dl) . "\n";
$message .= "HopsToLive=$hop\n";


print SOCK $message;
close (SOCK) || die "close: $!";


# Print the reply
&handledatareply();

close Server;

exit;






sub handledatareply {
    for ( ; $paddr2 = accept(Client,Server); close Client) {

	my($sourceport,$sourceaddress) = unpack_sockaddr_in($paddr2);
	if ($iaddr ne $sourceaddress) {
	    next;
	}

	my $messagetype = <Client>;
	my(%fields, $field);      # read field values
	while (defined($field = <Client>) && ($field  =~ /\=/)) {
	    my($fieldname, $fieldvalue) = split('=',$field);
	    chop $fieldvalue;      #dump \n at the end of every field
	    $fields{$fieldname} = $fieldvalue;
	};
  
	if ($messagetype =~ /HandshakeRequest/) {
	    my( $haddr, $hprotoname, $hremote, $hport, $hiaddr, $hpaddr, $hproto );
	    ($hprotoname, $haddr) = split(/\//,$fields{'Source'});
	    ($hremote, $hport) = split(/\:/,$haddr);
	    $hiaddr   = inet_aton($hremote) || die "no host: $hremote";
	    $hpaddr   = pack_sockaddr_in($hport, $hiaddr);
	    $hproto   = getprotobyname($hprotoname);
	    socket(HSOCK, PF_INET, SOCK_STREAM, $hproto)  || die "socket: $!";
	    connect(HSOCK, $hpaddr) || die "connect: $!";
	    $message = "HandshakeReply\n";
	    $message .= "Depth=$fields{'Depth'}\n";
	    $message .= "HopsToLive=$fields{'HopsToLive'}\n";
	    $message .= "UniqueID=$fields{'UniqueID'}\n";
	    $message .= "Source=tcp/$myhost:$myport\n";
	    $message .= "Version=$FREENETPROTO\n";
	    $message .= "EndMessage\n";
	    print HSOCK $message;
	    close HSOCK;
	} elsif ($messagetype =~ /DataReply/) {
	    if ($fields{'UniqueID'} ne $id) {
		next;
	    }
	    
	    # Try not to gag, this is temporary.  I need metadata.
	    if (($key =~ m/.*\.html$/i) or ($key =~ m/.*\/$/i)) {
		print "Content-type: text/html\n\n";
	    } elsif ($key =~ m/.*\.gz$/i) {
		print "Content-type: application/gzip\n\n";
	    } elsif (($key =~ m/.*\.jpg$/i) or ($key =~ m/.*\.jpeg$/i)) {
		print "Content-type: image/jpeg\n\n";
	    } elsif ($key =~ m/.*\.gif$/i) {
		print "Content-type: image/gif\n\n";
	    } elsif ($key =~ m/.*\.png$/i) {
		print "Content-type: image/png\n\n";
	    } elsif ($key =~ m/.*.mp3$/i) {
		print "Content-type: audio/x-mpeg3\n\n";
	    } else {
		print "Content-type: text/plain\n\n";
	    }

	    while (defined(my $line = <Client>)) {
		print $line;
	    }
	    last;
	} elsif ($messagetype =~ /RequestFailed/) {
	    if ($fields{'UniqueID'} ne $id) {
		next;
	    }
	    print "Content-type: text/plain\n\n";
	    print "Requested key not found.\n";
	    last;
	} elsif ($messagetype =~ /TimedOut/) {
	    if ($fields{'UniqueID'} ne $id) {
		next;
	    }
	    print "Content-type: text/plain\n\n";
	    print "Request timed out.\n";
	    last;
	} else {
	    if ($fields{'UniqueID'} ne $id) {
		next;
	    }
	    print "Content-type: text/plain\n\n";
	    print "Received invalid reply.\n";
	    last;
	}
    }
}






# SHA-1 in Perl
sub sha1hex {
  my ( $instr ) = @_;
  my ( @A, @K, @F, @W, $total, $bytes, $padded, $t, $a, $b, $c, $d, $e, $r, $r20 );

  # Initial values
  @A = ( 0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0 );
  # Constants used in algorithm
  @K = ( 0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6 );
  # Four different nonlinear functions used in different iterations
  @F = (sub{$b&($c^$d)^$d},sub{$b^$c^$d},sub{($b|$c)&$d|$b&$c},sub{$b^$c^$d});
  # Fix overflowing adds to be mod 2^32
  sub addfix{
   my( $val ) = @_;
   my( $denom );
   $denom = 1 + ~0;
   return $val - ($denom * int( $val/$denom ));
   };
  # Rotate left the specified amount
  sub lrotate{
   my( $val, $rot ) = @_;
   my( $mask );
   $mask = 2**$rot - 1;
   return ($val<<$rot) | (($val>>(32-$rot)) & $mask);
   }

  # Loop for each 512 bit block of input
  do {
   # Get next 512 bits of input
   $_ = substr($instr, 0, 64);
   substr($instr, 0, 64) = "";
   $total += $bytes = length $_;

   # Add byte of 0x80 after last byte of input
   if( $bytes < 64 && !$padded ) {
     $bytes++;
     $_ .= "\x80";
     $padded = 1;
   }

   # Convert 64 bytes of input into 16 words
   @W = unpack "N16", $_ . "\0"x64;

   # If last block, set total bit length in last word.
   if ($bytes <= 56) {
     $W[15] = $total*8;
   }

   # Fill rest of word array.  Note that lrotate distinguishes SHA-1 from SHA.
   for $r (16..79){
    $W[$r] = lrotate($W[$r-3]^$W[$r-8]^$W[$r-14]^$W[$r-16], 1)
   }

   # Get state variables $a - $e.
   ($a,$b,$c,$d,$e) = @A;

   # Loop for 80 rounds
   for $r (0..79){
    # Do one round of SHA transformation
    $r20 = $r / 20;
    $t = addfix( lrotate($a, 5) + &{$F[$r20]} + $e + $W[$r] + $K[$r20] );
    $e = $d;
    $d = $c;
    $c = lrotate($b, 30);
    $b = $a;
    $a = $t
   }

   # Add back into initial state variables to finish processing this block
   $A[0] = addfix($A[0]+$a);
   $A[1] = addfix($A[1]+$b);
   $A[2] = addfix($A[2]+$c);
   $A[3] = addfix($A[3]+$d);
   $A[4] = addfix($A[4]+$e);
  } while ($bytes > 56);

  # Done, return in Freenet format
  return sprintf( "%.8X"x5, @A );
}
