
package Freenet.client;
import java.io.*;
import java.math.*;
import java.util.*;
import Freenet.*;
import Freenet.crypt.*;
import Freenet.support.*;
import Freenet.message.*;

public class NameListRequestClient
{
    private Address nodeAddress;
    private ListeningAddress myAddress;
    private long hopsToLive;
    private long startDepth;

    public ClientNode cn;

    static public void main(String[] args)
    {
	if(args.length<2)
	    {
		System.out.println("usage: java Freenet.client.NameListRequestClient port address");
		System.out.println("ex.: java Freenet.client.NameListRequestClient 19115 tcp/localhost:19114");
		return;
	    }

	Node.connectTimeout = 30000;
        Node.handshakeTimeout = 30000;

	ListeningAddress lstaddr=new ListeningAddress("tcp/" + args[0]);
	Address addr=new Address(args[1]);
	SHA1 sha = new SHA1(true);
	long htl = (long)5;

        Node.connectTimeout=10000;
        Node.timer=new Ticker(500);

	NameListRequestClient rc = new NameListRequestClient(addr, lstaddr, htl, (Math.abs((new Random()).nextLong()) % 30));
	
	DataReply reply;
        InputStream stream;
	
	try {
            rc.getHandshake();
	    reply = rc.request();
            System.out.println(reply);
            stream=reply.in;
        } catch(BadHandshakeException e) {
            System.out.println("Bad handshake from node");
            return;
	} catch (SendFailedException sfe) {
	    System.out.println("Sending request failed, try a different node");
	    return;
	} catch (ClientException ce) {
	    if (ce.msg instanceof RequestFailed) {
		System.out.println("Request Failed"); 
	    } else if (ce.msg instanceof TimedOut) {
		System.out.println("Request Timed Out");
	    } else {
		System.out.println("Recieved unknown reply");
	    }
	    return;
	}

	try {
	    FileOutputStream out=new FileOutputStream("result");
            DotCounter counter=new DotCounter(1024);
	    Conduit cond=new Conduit(stream, out, counter);
	    cond.syncFeed();
	    stream.close();
	    out.close();
            if(!reply.length.equals(new BigInteger(new Long(counter.getTotal()).toString())))
	      System.out.println("Received truncated reply: "+reply.length + " | " + counter.getTotal());
	} catch(IOException e) {
	    System.out.println(e);
	}
    }

     public void getHandshake() throws BadHandshakeException
     {
             HandshakeReply shake=null;
             if(!cn.getHandshake(nodeAddress,false))
             {
               try { shake=(HandshakeReply)cn.acceptHandshake(); if(shake==null) throw new InvalidMessageException("Bad handshake"); }
               catch(InvalidMessageException e)
               {
                 System.out.println("Could not get handshake from node");
                 throw new BadHandshakeException();
               }
               if(!shake.check())
               {
                 System.out.println("Node is not compatible with client");
                 throw new BadHandshakeException();
               }
             }
             Node.handshakes.put(nodeAddress,new Date());
    }

    public NameListRequestClient(Address addr, ListeningAddress myAddr, long htl, long dpth)
    {

	myAddress = myAddr;
	nodeAddress = addr;
	hopsToLive = htl;
	startDepth = dpth;
	cn = new ClientNode(myAddr);

    }

    public DataReply request() throws ClientException, SendFailedException, BadHandshakeException
    {
	NameListRequest dr=new NameListRequest((new Random()).nextLong(), hopsToLive, startDepth);

	Message response = null;

	cn.sendMessage(dr, nodeAddress);

	boolean failed;
	do {
	    failed = false;
	    try {
		response = cn.acceptMessage();
                System.out.println("response: "+response);
	    } catch(InvalidMessageException e) {
		Logger.log("client/NameListRequestClient","Got broken response:" + e,Logger.MINOR);
		failed = true;
	    }
	    if (response instanceof QueryRestarted) {
		Logger.log("client/NameListRequestClient","The request got stuck on a broken node but has been restarted at a depth of " + response.depth,Logger.MINOR);
		failed = true;
	    }
            else if (response instanceof HandshakeRequest)
            {
              Logger.log("client/NameListRequestClient","Node requested a handshake",Logger.MINOR);
              response.received((Node)cn, (MessageMemory)null);
              failed = true;
            }
            else
            {
	      try { cn.checkid(response, dr.id); }
              catch(InvalidMessageException e)
              {
                Logger.log("client/NameListRequestClient","Got broken response:" + e,Logger.MINOR);
                failed=true;
              }      
            }
	} while (failed);
    
	if (!(response instanceof DataReply)) {
	    throw new ClientException(response);
	} else {
	    DataReply dp=(DataReply)response;
	    return dp;
	}
    }
}
