<?xml version='1.0'?>
<!-- Block elements for HTML transforms -->
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version="1.0">

<xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01//EN"
  doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

<xsl:template match="abstract">
  <h2>Abstract</h2>
  <xsl:apply-templates/>
</xsl:template>

<!-- TODO: address element -->

<xsl:template match="blockquote">
  <blockquote>
    <xsl:apply-templates/>
    <br />
    <xsl:apply-templates select="attribution" mode="quote.attribution.mode"/> 
  </blockquote>
</xsl:template>

<xsl:template match="attribution"></xsl:template>
<xsl:template match="attribution" mode="quote.attribution.mode">
  <xsl:text>--</xsl:text><i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="epigram">
  <blockquote class="epigram">
    <xsl:apply-templates/>
    <br />
    <xsl:apply-templates select="attribution" mode="quote.attribution.mode"/> 
  </blockquote>
</xsl:template>

<xsl:template match="note">
  <blockquote class="note">
    <xsl:apply-templates/>
  </blockquote>
</xsl:template>

<!-- HTML hack: browsers generally use P tags to mark breaks
     between paragraphs, so here we only output P tags for
     all but the first paragraph of a list item. -->

<xsl:template match="listitem/para[1]">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="member/para[1]">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="para">
  <p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="literallayout">
  <pre><xsl:apply-templates/></pre>
</xsl:template>

<xsl:template match="programlisting">
  <pre><code><xsl:apply-templates/></code></pre>
</xsl:template>

</xsl:stylesheet>
