<?xml version='1.0'?>
<!-- Transforms for Freenet FAQ -->
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version="1.0">
<xsl:import href="web.xsl"/>

<xsl:output method="html"
  media-type="text/html"
  cdata-section-elements="verbatim"
  doctype-public="-//W3C//DTD HTML 4.01//EN"
  doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

<xsl:template match="article">
  <html>
    <head>
      <xsl:comment>This file is automatically generated: do not edit.
      </xsl:comment>
      <xsl:apply-templates select="artheader" mode="header.mode"/>
    </head>
    <body>
      <div class="ldc">
        <h1><xsl:value-of select="artheader/title"/></h1>
        <ul>
          <xsl:apply-templates mode="toc.mode"/>
        </ul>
        <hr />
        <xsl:apply-templates/>
      </div>
    </body>
  </html>
</xsl:template>

<xsl:template match="qandadiv" mode="toc.mode">
  <xsl:variable name="sid">
    <xsl:number from="qandaset" count="qandadiv"/>
  </xsl:variable>
  <li><xsl:value-of select="$sid"/>. <a href="#sec{$sid}"><xsl:value-of select="title"/></a>
    <ul>
      <xsl:apply-templates mode="toc.mode"/>
    </ul>
  </li>
</xsl:template>
<xsl:template match="qandadiv">
  <xsl:variable name="sid">
    <xsl:number from="qandaset" count="qandadiv"/>
  </xsl:variable>
  <xsl:text>
</xsl:text>
  <h2><a name="{$sid}"><xsl:value-of select="$sid"/>. <xsl:value-of select="title"/></a></h2>
  <xsl:apply-templates/>
</xsl:template>
<xsl:template match="qandadiv/title"></xsl:template>

<xsl:template match="question" mode="toc.mode">
  <xsl:variable name="sid">
    <xsl:number from="qandaset" count="qandadiv"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="qandadiv" count="qandaentry"/>
  </xsl:variable>
  <li><xsl:value-of select="$sid"/>. <a href="#sec{$sid}"><xsl:value-of select="."/></a></li>
</xsl:template>
<xsl:template match="question">
  <xsl:variable name="sid">
    <xsl:number from="qandaset" count="qandadiv"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="qandadiv" count="qandaentry"/>
  </xsl:variable>
  <h3><a name="sec{$sid}"><xsl:value-of select="$sid"/>. <xsl:value-of select="."/></a></h3>
</xsl:template>

<xsl:template match="answer/date"></xsl:template>
<xsl:template match="answer/author"></xsl:template>

</xsl:stylesheet>
