<?xml version='1.0'?>
<!-- Inline elements for HTML transforms -->
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version="1.0">

<xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01//EN"
  doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

<xsl:template match="application"><i><xsl:apply-templates/></i></xsl:template>
<xsl:template match="citation"> [<xsl:apply-templates/>] </xsl:template>
<xsl:template match="citetitle"><cite><xsl:apply-templates/></cite></xsl:template>
<xsl:template match="emphasis"><em><xsl:apply-templates/></em></xsl:template>
<xsl:template match="foreignphrase"><i><xsl:apply-templates/></i></xsl:template>
<xsl:template match="firstterm"><i><xsl:apply-templates/></i></xsl:template>
<xsl:template match="glossterm"><xsl:apply-templates/></xsl:template>
<xsl:template match="indexterm"></xsl:template>
<xsl:template match="isbn"><b><xsl:apply-templates/></b></xsl:template>
<xsl:template match="issn"><b><xsl:apply-templates/></b></xsl:template>
<xsl:template match="literal"><code><xsl:apply-templates/></code></xsl:template>
<xsl:template match="quote">&quot;<xsl:apply-templates/>&quot;</xsl:template>
<xsl:template match="replaceable"><i>&lt;<xsl:apply-templates/>&gt;</i></xsl:template>

<xsl:template match="v"><xsl:value-of select="." disable-output-escaping="yes"/>
</xsl:template>

<xsl:template match="email">
  <a href="mailto:{normalize-space(.)}"><xsl:value-of select="."/></a>
</xsl:template>

<xsl:template match="link[@type='web']">
  <a href="{@linkend}"><xsl:apply-templates/></a>
</xsl:template>
<xsl:template match="link[@type='email']">
  <a href="mailto:{@linkend}"><xsl:apply-templates/></a>
</xsl:template>

<xsl:template match="trademark[@class='registered']">
  <xsl:apply-templates/><xsl:text disable-output-escaping="yes">&amp;reg;</xsl:text>
</xsl:template>
<xsl:template match="trademark[@class='service']">
  <xsl:apply-templates/><sup><small>SM</small></sup>
</xsl:template>
<xsl:template match="trademark">
  <xsl:apply-templates/><sup><small>TM</small></sup>
</xsl:template>

</xsl:stylesheet>
