<?xml version='1.0'?>
<!-- List elements for HTML transforms -->
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version="1.0">

<xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01//EN"
  doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

<xsl:template match="simplelist">
  <xsl:if test="title">
    <h4><xsl:value-of select="title"/></h4>
  </xsl:if>
  <ul>
    <xsl:apply-templates/>
  </ul>
</xsl:template>

<xsl:template match="itemizedlist">
  <xsl:if test="title">
    <h4><xsl:value-of select="title"/></h4>
  </xsl:if>
  <ul type="disc">
    <xsl:apply-templates/>
  </ul>
</xsl:template>

<xsl:template match="orderedlist">
  <xsl:if test="title">
    <h4><xsl:value-of select="title"/></h4>
  </xsl:if>
  <ol>
    <xsl:apply-templates/>
  </ol>
</xsl:template>

<xsl:template match="variablelist">
  <xsl:if test="title">
    <h4><xsl:value-of select="title"/></h4>
  </xsl:if>
  <dl>
    <xsl:apply-templates/>
  </dl>
</xsl:template>

<xsl:template match="varlistentry/term">
  <dt><xsl:apply-templates/></dt>
</xsl:template>

<xsl:template match="varlistentry/listitem">
  <dd><xsl:apply-templates/></dd>
</xsl:template>

<xsl:template match="listitem|member">
  <li><xsl:apply-templates/></li>
</xsl:template>

</xsl:stylesheet>
