<H1>Specification of Freenet Protocol v1.0</H1>
<FONT color="red"><B>This document is incomplete!</B></FONT><BR>
<B>Document version:</B> 0.3 - 9th Feb 2000<BR>
<B>Protocol design:</B> 
   <A HREF="mailto:I.Clarke@dynamicblue.com">Ian Clarke</A><BR>
<B>Document authors:</B> 
<A HREF="mailto:I.Clarke@dynamicblue.com">Ian Clarke</A> and
<A HREF="mailto:blanu@uts.cc.utxas.edu">Brandon Wiley</A>.
<H3>1 Introduction</H3>
    Freenet messages are designed to be transmitted over a stream-based
    reliable protocol such as TCP/IP.  They are designed to be
    extensible in such a way that nodes can handle even unrecognized
    message-types in a reasonable manner, this is achieved through a
    system similar to subclassing in object orientated programming.
<H3>2 General format of messages</H3>
<H4>2.1 Message type</H4>
    Each message begins with a string terminated by a carriage return
    which indicates the type of message, for example:<BR>
    <PRE>
    DataReply
    </PRE>
    The message type may optionally have a sub-type appended as follows:<BR>
    <PRE>
    DataReply.CHDataReply
    </PRE>
    The message represented by this should contain all fields present
    in a DataReply, and optionally some additional fields.  If a node
    receives such a message and doesn't know how to handle a
    CHDataReply the message will be treated as a DataReply.
<H4>2.2 Normal fields</H4>
    Each message will contain 0 or more fields, which consist of a
    name,value pair.  Normal fields within the message are of the
    form:<BR>
    <PRE>
    fieldname=fieldvalue
    </PRE>
    The fieldvalue is terminated by a carriage return.
<H4>2.3 Trailing field</H4>
    Optionally, a message may contain a "trailing field".  The purpose 
    of this field is to allow the value associated with one of the
    field names to be a stream, rather than  a string.  The trailing
    field is of the form:<BR>
    <PRE>
    trailingfieldname-trailingfieldlength
    trailing..field..data..........
    ....which...may...continue...
    ..over...several....lines......
    </PRE>
    Note that the trailing field data may contain any ASCII characters 
    <I>including</I> carriage returns since the length of the trailing 
    field is specified prior to the trailing field being transmitted.
    <H4>2.4 Encodings</H4>
    <H5>2.4.1 Address</H5>
    All Freenet addresses are in the form:<BR> 
    <PRE>
    protocol/data
    </PRE>  
    Currently the only defined protocol is "tcp".  A TCP Address
    refers to a node attached to an IP address on the Internet which
    will accept connections on a particular port.  TCP Addresses are
    formatted as follows:
    <PRE>
    tcp/ipaddress:port
    </PRE>
    For example:
    <PRE>
    tcp/194.168.134.100:19114
    </PRE>
    <H4>2.5 Compulsory fields</H4>
    <H5>2.5.1 UniqueID</H5>
    <TABLE>
      <TR>
	<TD><B>Purpose:</B></TD><TD>Uniquely identify this message and related
	  messages</TD>
      </TR>
      <TR>
	<TD><B>Form:</B></TD><TD>
	  ASCII string representation of a positive 32bit integer</TD>
      </TR>
      <TR>
	<TD><B>Generated:</B></TD><TD>Random</TD>
      </TR>
      <TR>
	<TD><B>Behaviour:</B></TD>
	<TD>If a message is initiated by another message, by default
	the UniqueID of the new message will be set to the UniqueID of
	the old message.</TD>
      </TR>
    </TABLE>
    <H5>2.5.2 HopsToLive</H5>
    <TABLE>
      <TR>
	<TD><B>Purpose:</B></TD><TD>Ensure that messages do not get into infinite 
	  loops</TD>
      </TR>
      <TR>
	<TD><B>Form:</B></TD><TD>
	  ASCII string representation of a positive integer</TD>
      </TR>
      <TR>
	<TD><B>Generated:</B></TD><TD>Set randomly to a value close to a 
	  pre-defined maximum (currently 256)</TD>
      </TR>
      <TR>
	<TD><B>Behaviour:</B></TD>
	<TD>decrement and pass.  if this field is ever zero, drop the
	  message and generate and send a TimedOut message to the address
	  in the Source field.  Source</TD>
      </TR>
    </TABLE>
    <H5>2.5.3 Source</H5>
    <TABLE>
      <TR>
	<TD><B>Purpose:</B></TD><TD>Identify the node which transmitted this
	  message.</TD>
      </TR>
      <TR>
	<TD><B>Form:</B></TD><TD>
	  Address</TD>
      </TR>
      <TR>
	<TD><B>Generated:</B></TD><TD>Set by a node to its own address 
	  before sending a message.</TD>
      </TR>
    </TABLE>
    <H3>3 Details of current message types</H3>
    <H4>3.1 DataRequest</H4>
    <H5>3.1.1 Literal Meaning</H5>
    Please return a DataReply containing the data associated with the
    SearchKey field, or if this is not possible return a
    RequestFailed.
    <H5>3.1.2 Recommended Behaviour</H5>
    If the node has a local copy of the data associated with the
    SearchKey, then the node should construct a DataReply containing
    that data and return it to the source node.  If not, the node
    should forward the DataRequest to another node which is more
    likely to have the data corresponding to the SearchKey.  If a
    DataReply is received the DataReply should be forwarded to the
    source node of the DataRequest.  If a RequestFailed is received
    then the node should send another DataReply to the "next-best"
    node.  If all possibilities have been exhausted a RequestFailed
    should be sent to the source node of the DataRequest.
    <H5>3.1.3 Initiated by</H5>
    <UL>
      <LI>DataRequest
      <LI>RequestFailed
      <LI>[User]
    </UL>
    <H5>3.1.4 Initiates</H5>
    <UL>
      <LI>DataReply
      <LI>DataRequest
      <LI>RequestFailed
      <LI>TimedOut
    </UL>
    <H5>3.1.5 Fields</H5>
    <H6>3.1.5.1 SearchKey</H6>
        <TABLE>
      <TR>
	<TD><B>Purpose:</B></TD><TD>Specify the key which corresponds
	to the information that is desired.</TD>
      </TR>
      <TR>
	<TD><B>Form:</B></TD><TD>
	  ASCII String</TD>
      </TR>
      <TR>
	<TD><B>Generated:</B></TD><TD>Set by the user, or from the
	  DataRequest which initiated this message.
	</TD>
      </TR>
    </TABLE>
    <H4>3.2 DataReply</H4>
    <H4>3.3 DataInsert</H4>
    <H4>3.4 RequestFailed</H4>
    <H4>3.5 TimedOut</H4>