<?xml version='1.0'?>
<!-- Stylesheet for converting XML DocBook-style input files into HTML.
     This is designed for input files that consist of a single <article>
     element, and contain a small subset of the full DocBook DTD selected
     for the Freenet FAQ and spec documents.  The HTML ouput document
     will reference the "freenet.css" stylesheet.
-->
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version="1.0">
<xsl:import href="inlines.xsl"/>
<xsl:import href="lists.xsl"/>
<xsl:import href="blocks.xsl"/>

<xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01//EN"
  doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

<xsl:template match="article">
  <html>
    <head>
      <xsl:comment>This file is automatically generated: do not edit.
      </xsl:comment>
      <xsl:apply-templates select="artheader" mode="header.mode"/>
    </head>
    <body>
      <div class="ldc">
        <h1><xsl:value-of select="artheader/title"/></h1>
        <xsl:if test="abstract">
          <h2>Abstract</h2>
          <xsl:apply-templates select="abstract" mode="front.mode"/>
        </xsl:if>
        <div class="toc">
          <h2>Contents</h2>
          <ul>
            <xsl:apply-templates mode="toc.mode"/>
          </ul>
        </div>
        <hr />
        <div class="detail">
          <xsl:apply-templates/>
        </div>
      </div>
    </body>
  </html>
</xsl:template>

<xsl:template match="artheader" mode="header.mode">
  <link rel="stylesheet" href="freenet.css" type="text/css"/>
  <title><xsl:value-of select="title"/></title>
  <xsl:for-each select="./*">
    <xsl:comment>
      <xsl:value-of select="local-name(.)"/>: <xsl:value-of select="."/>
    </xsl:comment>
  </xsl:for-each>
</xsl:template>
<xsl:template match="artheader"></xsl:template>
<xsl:template match="*" mode="header.mode"></xsl:template>

<xsl:template match="abstract"/>
<xsl:template match="abstract" mode="front.mode">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="title"/>
<xsl:template match="text()" mode="toc.mode"></xsl:template>

<xsl:template match="sect1" mode="toc.mode">
  <xsl:variable name="sid">
    <xsl:number from="article" count="sect1"/>
  </xsl:variable>
  <li><xsl:value-of select="$sid"/>. <a href="#sec{$sid}"><xsl:value-of select="title"/></a>
    <xsl:if test="sect2">
      <ul>
        <xsl:apply-templates mode="toc.mode"/>
      </ul>
    </xsl:if>
  </li>
</xsl:template>
<xsl:template match="sect1">
  <xsl:variable name="sid">
    <xsl:number from="article" count="sect1"/>
  </xsl:variable>
  <xsl:text>
</xsl:text>
    <h1><a name="sec{$sid}"><xsl:value-of select="$sid"/>. <xsl:value-of select="title"/></a></h1>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="sect2" mode="toc.mode">
  <xsl:variable name="sid">
    <xsl:number from="article" count="sect1"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="sect1" count="sect2"/>
  </xsl:variable>
  <li><xsl:value-of select="$sid"/>. <a href="#sec{$sid}"><xsl:value-of select="title"/></a>
    <xsl:if test="sect3">
      <ul>
        <xsl:apply-templates mode="toc.mode"/>
      </ul>
    </xsl:if>
  </li>
</xsl:template>
<xsl:template match="sect2">
  <xsl:variable name="sid">
    <xsl:number from="article" count="sect1"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="sect1" count="sect2"/>
  </xsl:variable>
  <xsl:text>
</xsl:text>
  <h2><a name="sec{$sid}"><xsl:value-of select="$sid"/>. <xsl:value-of select="title"/></a></h2>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="sect3" mode="toc.mode">
  <xsl:variable name="sid">
    <xsl:number from="article" count="sect1"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="sect1" count="sect2"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="sect2" count="sect3"/>
  </xsl:variable>
  <li><xsl:value-of select="$sid"/>. <a href="#sec{$sid}"><xsl:value-of select="title"/></a></li>
</xsl:template>
<xsl:template match="sect3">
  <xsl:variable name="sid">
    <xsl:number from="article" count="sect1"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="sect1" count="sect2"/>
    <xsl:text>.</xsl:text>
    <xsl:number from="sect2" count="sect3"/>
  </xsl:variable>
  <xsl:text>
</xsl:text>
  <h3><a name="sec{$sid}"><xsl:value-of select="$sid"/>. <xsl:value-of select="title"/></a></h3>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="sect4">
  <h4><xsl:value-of select="title"/></h4>
  <xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>
